package cn.dolphin.core.dto;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;


/**
 * 类名：Dto<br>
 * 功能：数据传输对象接口<br>
 * 详细：对原生Java Map类型的二次包装，提供更加方便的存取API、更强的容错和类型转换机制<br>
 */
public interface Dto extends Map<String, Object>{



    /**
     * 功能：以Integer类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return Integer 键值
     */
    public Integer getInteger(String pKey);


    /**
     * 功能：以BigInteger类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return BigInteger 键值
     */
    public BigInteger getBigInteger(String pKey);


    /**
     * 功能：以Long类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return Long 键值
     */
    public Long getLong(String pKey);

    /**
     * 功能：以String类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return String 键值
     */
    public String getString(String pKey);


    /**
     * 功能：以BigDecimal类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return BigDecimal 键值
     */
    public BigDecimal getBigDecimal(String pKey);


    /**
     * 功能：以Date类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return Date 键值(yyyy-MM-dd)
     */
    public Date getDate(String pKey);


    /**
     * 功能：以Timestamp类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return Timestamp 键值(yyyy-MM-dd HH:mm:ss)
     */
    public Timestamp getTimestamp(String pKey);


    /**
     * 功能：以Boolean类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return Boolean 键值
     */
    public Boolean getBoolean(String pKey);

    /**
     * 功能：以List类型返回属性<br>
     * 详细：<br>
     * 作者：by heqing.y<br>
     * 参数：<br>
     * @param pKey
     * @return List 键值
     */
    public List<? extends Object> getList(String pKey);


}

