package cn.dolphin.core.dialect;


/**
 * 类似hibernate的Dialect,但只精简出分页部分
 */
public class Dialect {

    public boolean supportsLimit(){
        return false;
    }

    public boolean supportsLimitOffset() {
        return supportsLimit();
    }

    /**
     * 将sql变成分页sql语句,直接使用offset,limit的值作为占位符
     * 源代码为: getLimitString(sql,offset,String.valueOf(offset),limit,String.valueOf(limit))
     * @param sql sql语句
     * @param offset 记录编号
     * @param limit 页大小
     * @return
     */
    public String getLimitString(String sql, int offset, int limit) {
        return getLimitString(sql,offset,Integer.toString(offset),limit,Integer.toString(limit));
    }


    /**
     * 将sql变成分页sql语句,提供将offset及limit使用占位符(placeholder)替换
     * 如mysql
     * dialect.getLimitString("select * from user", 12, ":offset",0,":limit") 将返回
     * select * from user limit :offset,:limit
     * @param sql
     * @param offset
     * @param offsetPlaceholder
     * @param limit
     * @param limitPlaceholder
     * @return
     */
    public String getLimitString(String sql, int offset,String offsetPlaceholder, int limit,String limitPlaceholder) {
        throw new UnsupportedOperationException("paged queries not supported");
    }


    /**
     * 将sql转换为总记录数SQL
     * @param sql SQL语句
     * @return 总记录数的sql
     */
    public String getCountSql(String sql){
        return "select count(1) from (" + sql + ") tmp_count";
    }

    /**
     * 嵌套查询算总数去重
     * @param sql
     * @return
     */
    public String getCountSqlDistinct(String sql){
        return " select  count(1) from (select distinct * from (" + sql + ") tmp_count) tmp_count";
    }

    /**
     * 将sql转换为总记录数SQL
     * @param sql SQL语句
     * @param countField 需要统计的字段
     * @return
     */
    public String getCountSql(String sql ,String countField){
        String countSql = String.format("select count(%s) from (" + sql + ") tmp_count", new Object[]{countField == null?"1":countField});
        return countSql;
    }


    /**
     * 字段或表名上的引号：mysql为：``，oracle为：""
     * 默认mysql
     * @return
     */
    public String getMark() {
        return "`";
    }



}

