package cn.dolphin.core.db;

import cn.dolphin.core.page.PageBean;

import java.io.Serializable;
import java.util.List;

/**
 * DAO接口
 * 默认支持添加，删除，更新，查询，分页方法。
 */
public interface IEntityDao<E, PK extends Serializable> {


    /**
     * 添加对象
     * @param entity
     * @return
     */
    public void saveMyBatis(E entity) throws Exception;

    /**
     * 根据主键删除
     * @param id
     */
    public int deleteMyBatisById(PK id) throws Exception;

    /**
     * 更新对象
     * @param entity
     */
    public int updateMyBatis(E entity) throws Exception;

    /**
     * 根据主键ID取得对象
     * @param id
     * @return
     */
    public Object getMyBatisById(PK id) throws Exception;

    /**
     * 根据条件获取列表数据
     * @param statementName
     * @param params
     * @return
     */
    public List<E> getMyBatisList(String statementName, Object params) throws Exception;


    /**
     * 按某一SQL取得分页的数据列表
     * @return
     */
    public List<E> getMyBatisList(String statementName, Object params, PageBean pb) throws Exception;

    /**
     * 获取该表的所有记录
     * @return
     */
    public List<E> getMyBatisAll() throws Exception;

    /**
     * 返回某一条单独的数据
     * @param sqlKey map xml 中的语句Id
     * @param params
     * @return
     */
    public E getMyBatisUnique(String sqlKey,Object params) throws Exception;

}
