package cn.dolphin.core.db;

import cn.dolphin.core.jdbc.JdbcTemplatePlus;
import cn.dolphin.core.jdbc.support.CommonObj;
import cn.dolphin.core.mybatis.SqlMapper;
import cn.dolphin.core.spring.SpringContextUtil;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.jdbc.core.RowMapper;

import java.io.Serializable;

/**
 * 数据库操作基类。<br>
 * 包含基本的操作：增，查，改，删，列表，分页操作。
 */
public abstract class BaseDao <E, PK extends Serializable> extends GenericDao<E, PK>{

    public BaseDao() {
    }

    /**
     * 设置mybatis
     * @param sqlSessionFactory
     */
    public BaseDao(SqlSessionFactory sqlSessionFactory) {
        setSqlSessionFactory(sqlSessionFactory);
    }
    /**
     * 设置jdbc
     * @param jdbcTemplatePlus
     */
    public BaseDao(JdbcTemplatePlus jdbcTemplatePlus) {
        setJdbcTemplatePlus(jdbcTemplatePlus);
    }

    /**
     * 设置jdbc和mybatis
     * @param jdbcTemplatePlus
     */
    public BaseDao(JdbcTemplatePlus jdbcTemplatePlus,SqlSessionFactory sqlSessionFactory) {
        setJdbcTemplatePlus(jdbcTemplatePlus);
        setSqlSessionFactory(sqlSessionFactory);
    }

    /**
     * 数据库连接ThreadLocal
     */
    ThreadLocal<JdbcTemplatePlus> jdbc = new ThreadLocal<JdbcTemplatePlus>();

    private JdbcTemplatePlus jdbcTemplatePlus;

    /**
     * 设置jdbc
     * @param jdbcTemplatePlus
     */
    public void setJdbcTemplatePlus(JdbcTemplatePlus jdbcTemplatePlus) {
        this.jdbcTemplatePlus = jdbcTemplatePlus;
    }

    /**
     * 设置mybatis
     * @param sqlSessionFactory
     */
    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        super.setSqlSessionFactory(sqlSessionFactory);
    }

    /**
     * 获取数据库连接
     * 采用该方法是为了兼容在其它项目中没有使用JdbcTemplatePlus的情况
     * @return
     */
    @Override
    public JdbcTemplatePlus getJdbcTemplate() {

        if(jdbcTemplatePlus == null){
            jdbcTemplatePlus = jdbc.get();
            if(jdbcTemplatePlus == null) {
                jdbcTemplatePlus = SpringContextUtil.getBean(JdbcTemplatePlus.class);
                jdbc.set(jdbcTemplatePlus);
            }
        }

        return jdbcTemplatePlus;
    }

    /**
     * 自动注入实体
     * @return
     */
    @Override
    public Class<?> getEntityClass() {
        return entityClass;
    }

    /**
     * 默认组装对象RowMapper
     * @return
     */
    @Override
    protected RowMapper<E> getRowMapper() {
        return new CommonObj(getEntityClass());
    }

    /**
     * SQL语句通用mapper
     * @return
     */
    @Override
    public SqlMapper sqlMapper() {

        SqlMapper sqlMapper = new SqlMapper(openSession());
        return sqlMapper;
    }

}
