package cn.dolphin.core.date;

import cn.dolphin.core.consts.P;

import java.sql.Time;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * 日起格式化
 */
@SuppressWarnings("all")
public class DateUtil8 {
    private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE = new ConcurrentHashMap<>();

    private DateUtil8() {
    }

    public static String formatDate(long l) {
        return formatDate(new Date(l));
    }

    public static String formatDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(P.DATE_FORMAT_DATE));
    }

    public static String formatTime(long l) {
        return formatTime(new Date(l));
    }

    public static String formatTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(P.DATE_FORMAT_TIME));
    }

    public static String formatDateTime(long l) {
        return formatDateTime(new Date(l));
    }

    public static String formatDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(P.DATE_FORMAT_DATETIME));
    }

    public static String formatCompactDate(long l) {
        return formatCompactDate(new Date(l));
    }

    public static String formatCompactDate(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(P.DATE_FORMAT_COMPACT_DATE));
    }

    public static String formatCompactTime(long l) {
        return formatCompactTime(new Date(l));
    }

    public static String formatCompactTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(P.DATE_FORMAT_COMPACT_TIME));
    }

    public static String formatCompactDateTime(long l) {
        return formatCompactDateTime(new Date(l));
    }

    public static String formatCompactDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(P.DATE_FORMAT_COMPACT_DATETIME));
    }

    public static String format(long l, String format) {
        return format(new Date(l), format);
    }

    public static String format(Date date, String pattern) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatFor(pattern));
    }

    public static String formatChnTime(long l) {
        return formatChnTime(l, false);
    }

    public static String formatChnTime(long l, boolean trim) {
        if (l <= 0L)
            return "";
        long d = l / 86400000L;
        l %= 86400000L;
        long h = l / 3600000L;
        l %= 3600000L;
        long m = l / 60000L;
        l %= 60000L;
        long s = l / 1000L;
        StringBuilder sb = new StringBuilder();
        if (!trim || d != 0)
            sb.append(d).append("天");
        if (!trim || h != 0)
            sb.append(h).append("小时");
        if (!trim || m != 0)
            sb.append(m).append("分");
        if (!trim || s != 0)
            sb.append(s).append("秒");
        return sb.toString();
    }

    public static Calendar addDay(Date date, int deltaDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, deltaDay);
        return calendar;
    }

    public static Calendar addSecond(Date date, int deltaSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.SECOND, deltaSecond);
        return calendar;
    }

    public static Calendar add(Date date, int field, int deltaSecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, deltaSecond);
        return calendar;
    }

    public static Long dateDiff(Date firstDate, Date secondDate, int interval) {
        if ((firstDate == null) || (secondDate == null)) {
            return null;
        }

        switch (interval) {
            case 1:
                return Long.valueOf((firstDate.getTime() - secondDate.getTime()) / 1471228928L);
            case 2:
                return Long.valueOf((firstDate.getTime() - secondDate.getTime()) / -1702967296L);
            case 5:
            case 6:
            case 7:
            case 8:
                return Long.valueOf((firstDate.getTime() - secondDate.getTime()) / 86400000L);
            case 10:
            case 11:
                return Long.valueOf((firstDate.getTime() - secondDate.getTime()) / 3600000L);
            case 12:
                return Long.valueOf((firstDate.getTime() - secondDate.getTime()) / 60000L);
            case 13:
                return Long.valueOf((firstDate.getTime() - secondDate.getTime()) / 1000L);
            case 14:
                return Long.valueOf(firstDate.getTime() - secondDate.getTime());
            default:
                return null;
        }
    }

    public static Calendar getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(5));
        return calendar;
    }

    public static Date truncDate(Date date) {
        return parseDateTime(truncDateStr(date, 5));
    }

    public static Date truncDate(Date date, int field) {
        return parseDateTime(truncDateStr(date, field));
    }

    public static Date truncCurDate(int field) {
        return parseDateTime(truncDateStr(new Date(), field));
    }

    public static String truncDateStr(Date date, int field) {
        String fmt = null;
        switch (field) {
            case 13:
                break;
            case 12:
                fmt = "yyyy-MM-dd HH:mm:00";
                break;
            case 10:
            case 11:
                fmt = "yyyy-MM-dd HH:00:00";
                break;
            case 5:
                fmt = "yyyy-MM-dd 00:00:00";
                break;
            case 2:
                fmt = "yyyy-MM-01 00:00:00";
                break;
            case 1:
                fmt = "yyyy-01-01 00:00:00";
                break;
            default:
                fmt = "yyyy-MM-dd HH:mm:ss";
                break;
        }
        return format(date, fmt);
    }

    public static String truncCurDateStr(int field) {
        return truncDateStr(new Date(), field);
    }

    public static String truncCurDateStr() {
        return truncDateStr(new Date(), Calendar.DAY_OF_MONTH);
    }

    public static Time truncToSqlTime(Date date) {
        if (date == null) {
            return null;
        }
        Date dt = parseDateTime("1970-01-01 " + formatTime(date));
        return new Time(dt.getTime());
    }

    public static Date replaceTime(Date date, String timeStr) {
        return parseDateTime(formatDate(date) + " " + timeStr);
    }

    public static Date replaceDate(Date date, String dateStr) {
        return parseDateTime(dateStr + " " + formatTime(date));
    }

    public static String getCurDate() {
        return formatDate(new Date());
    }

    public static String getCurTime() {
        return formatTime(new Date());
    }

    public static String getCurDateTime() {
        return formatDateTime(new Date());
    }

    public static String getCurCompactDate() {
        return formatCompactDate(new Date());
    }

    public static String getCurCompactTime() {
        return formatCompactTime(new Date());
    }

    public static String getCurCompactDateTime() {
        return formatCompactDateTime(new Date());
    }

    public static String getCurDateTime(String format) {
        return format(new Date(), format);
    }

    public static Date parseDate(String str) {
        return parse(str, P.DATE_FORMAT_DATE);
    }

    public static Date parseTime(String str) {
        return parse(str, P.DATE_FORMAT_TIME);
    }

    public static Date parseDateTime(String str) {
        return parse(str, P.DATE_FORMAT_DATETIME);
    }

    public static Date parseCompactDate(String str) {
        return parse(str, P.DATE_FORMAT_COMPACT_DATE);
    }

    public static Date parseCompactTime(String str) {
        return parse(str, P.DATE_FORMAT_COMPACT_TIME);
    }

    public static Date parseCompactDateTime(String str) {
        return parse(str, P.DATE_FORMAT_COMPACT_DATETIME);
    }

    public static Date parse(String str, String format) {
        return Date.from(LocalDateTime.parse(str, formatFor(format)).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static int getCurUnixTimestamp() {
        return (int) (System.currentTimeMillis() / 1000L);
    }

    public static int getUnixTimestamp(Date date) {
        return (int) (date.getTime() / 1000L);
    }

    public static Date parseUnixTimestamp(int timestamp) {
        long tms = timestamp * 1000L;
        return new Date(tms);
    }

    private static DateTimeFormatter formatFor(String pattern){
        DateTimeFormatter formats= FORMATTER_CACHE.get(pattern);
        if (formats == null) {
            formats = DateTimeFormatter.ofPattern(pattern);
            FORMATTER_CACHE.put(pattern, formats);
        }
        return formats;
    }
}
