package cn.dolphin.core.consts;

/**
 * 基础状态码
 */
public class ResultConstant {

    /**
     * 成功
     */
    public static final String SUCCESS_CODE = "000000";
    public static final String SUCCESS_MSG = "成功";

    /**
     * 服务器内部错误
     */
    public static final String ERROR_SERVER_CODE = "000001";
    public static final String ERROR_SERVER_MSG = "服务器内部错误,操作失败";
    /**
     * 参数为空
     */
    public static final String ERROR_NULL_CODE = "000002";
    public static final String ERROR_NULL_MSG = "参数为空";

    /**
     * 参数错误
     */
    public static final String ERROR_CODE = "000003";
    public static final String ERROR_MSG = "参数错误";
    /**
     * 参数校验错误
     */
    public static final String ILLEGAL_CODE = "000004";
    public static final String ILLEGAL_MSG = "参数不符合规范";
    /**
     * 参数查询的数据为空
     */
    public static final String DATA_NULL_CODE = "000005";
    public static final String DATA_NULL_MSG = "数据为空";
    /**
     * 参数查询的数据不存在
     */
    public static final String DATA_NOT_FOUND_CODE = "000006";
    public static final String DATA_NOT_FOUND_MSG = "数据不存在";
    /**
     * 时间格式错误
     */
    public static final String DATE_FORMAT_ERROR_CODE = "000007";
    public static final String DATE_FORMAT_ERROR_MSG = "时间格式错误";
}
