package cn.dolphin.core.consts;

import java.util.Locale;

/**
 * 系统参数
 */
public class P {
    public static final String GBK = "GBK";

    public static final long B = 1;
    public static final long KB = 1024;
    public static final long MB = 1024 * 1024;
    public static final long GB = 1024 * 1024 * 1024;
    public static final long TB = 1024 * 1024 * 1024 * 1024;

    public static final double PI = 3.1415926535898d;

    public static final int STRING_CASE_NOR = 0;
    public static final int STRING_CASE_UP = 1;
    public static final int STRING_CASE_LOW = 2;

    /** 格式化数字百分号 */
    public static final String NUMBER_FORMAT_PERCENT = "##.##%";
    /** 格式化数字千分号 */
    public static final String NUMBER_FORMAT_PERMIL = "##.##\u2030";
    /** 格式化货币符号 */
    public static final String NUMBER_FORMAT_MONEY = "##.##¤";
    /** 格式化数字 */
    public static final String NUMBER_FORMAT_NUMBER = "##.##";
    /** 带,号的英国数字 */
    public static final String NUMBER_FORMAT_UK = "#,###.#";

    /** 紧凑日期时间格式: yyyyMMddHHmmss  */
    public static final String DATE_FORMAT_COMPACT_DATETIME = "yyyyMMddHHmmss";
    /** 紧凑日期格式: yyyyMMdd */
    public static final String DATE_FORMAT_COMPACT_DATE = "yyyyMMdd";
    /** 紧凑时间格式: yyyyMMddHHmmss */
    public static final String DATE_FORMAT_COMPACT_TIME = "HHmmss";
    /** 格式化(24小时制)<br> yyyy-MM-dd HH:mm:ss */
    public static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    /** 格式化(12小时制)<br> yyyy-MM-dd hh:mm:ss */
    public static final String DATE_FORMAT_DATETIME_12 = "yyyy-MM-dd hh:mm:ss";
    /** 格式化日期: yyyy-MM-dd  */
    public static final String DATE_FORMAT_DATE = "yyyy-MM-dd";
    /** 格式化(24小时制)时间: HH:mm:ss */
    public static final String DATE_FORMAT_TIME = "HH:mm:ss";
    /** 格式化(12小时制)时间: hh:mm:ss */
    public static final String DATE_FORMAT_TIME_12 = "hh:mm:ss";

    public static final String CIPHER_DES = "DES";
    public static final String CIPHER_AES = "AES";
    public static final String CIPHER_RSA = "RSA";
    public static final String CIPHER_BLOWFISH = "Blowfish";
    public static final String CIPHER_AES_CBC_PKCS5Padding = "AES/CBC/PKCS5Padding";
    /** 加密向量 */
    public static final String IV_DEFAULT = "1234567890654321";

    public static final String MESSAGE_DEGEST_MD2 = "MD2";
    public static final String MESSAGE_DEGEST_MD5 = "MD5";
    public static final String MESSAGE_DEGEST_SHA = "SHA";
    public static final String MESSAGE_DEGEST_SHA_224 = "SHA-224";
    public static final String MESSAGE_DEGEST_SHA_256 = "SHA-256";
    public static final String MESSAGE_DEGEST_SHA_384 = "SHA-384";
    public static final String MESSAGE_DEGEST_SHA_512 = "SHA-512";

    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR = LINE_SEPARATOR_WINDOWS;

    /**二进制16**/
    public static final int HASH_HEX = 0xf;

    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_JPG = "jpg";

    /** 连接超时 MS **/
    public static final int HTTP_CONNECT_TIMEOUT = 20000;
    /** 响应超时 MS **/
    public static final int HTTP_RESPONSE_TIMEOUT = 60000;
    /** 连接重试 **/
    public static final int HTTP_MAX_RETRY_COUNT = 1;
    /** 最大连接数 **/
    public static final int HTTP_MAX_TOTAL_CONNECTION = 1000;
    /** 每个端口最大连接数 **/
    public static final int HTTP_MAX_CONNECTION_PER_HOST = 250;

    public static final Locale LOCALE = new Locale("zh", "CN", "");
}
