package cn.dolphin.core.consts;

/**
 * 常用的数字模式
 */
public final class NumberPattern{

    /**
     * 整数,不含小数
     *
     * 示例:
     * 88.6 会被格式化成 89
     * -88.6 会被格式化成 -89
     */
    public static final String NO_SCALE             = "#";

    /**
     * (2位小数点)
     *
     * 示例:
     * 88.6 会被格式化成 88.60
     * -88.067 会被格式化成 -88.07
     */
    public static final String TWO_DECIMAL_POINTS   = "#0.00";

    //---------------------------------------------------------------

    /**
     * 百分数的表达式(不带小数)
     *
     * 示例:
     * 0 会被格式化成 0%
     * 1 会被格式化成 100%
     * 100 会被格式化成 10000%
     */
    public static final String PERCENT_WITH_NOPOINT = "##%";

    /**
     * 百分数的表达式(1位小数点)
     *
     * 示例:
     * 0 会被格式化成 0.0%
     * 1 会被格式化成 100.0%
     * 100 会被格式化成 10000.0%
     */
    public static final String PERCENT_WITH_1POINT  = "#0.0%";

    /**
     * 百分数的表达式(2位小数点)
     *
     * 示例:
     * 0 会被格式化成 0.00%
     * 1 会被格式化成 100.00%
     * 100 会被格式化成 10000.00%
     */
    public static final String PERCENT_WITH_2POINT  = "#0.00%";

    //---------------------------------------------------------------

    /** Don't let anyone instantiate this class. */
    private NumberPattern(){
        //AssertionError不是必须的. 但它可以避免不小心在类的内部调用构造器. 保证该类在任何情况下都不会被实例化.
        //see 《Effective Java》 2nd
        throw new AssertionError("No " + getClass().getName() + " instances for you!");
    }
}
