package cn.dolphin.core.consts;

import org.joda.time.DateTimeZone;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

/**
 * 时间常量
 */
@SuppressWarnings("all")
public final class DateConstant {

    /**
     * 开始时间值
     */
    public static final String TIME_START = " 00:00:00";

    /**
     * 终止时间值
     */
    public static final String TIME_END = " 23:59:59";

    /**
     * 中国时区
     */
    public static final String ZONE_CHAINA = "+8";

    /**
     * 时区
     */
    public static final String TIME_ZONE = "Asia/Shanghai";

    /**
     * joda.time时区 +08:00
     */
    public static final DateTimeZone JODA_TIME_ZONE = DateTimeZone.getDefault();
    /**
     * joda.time时区 +08:00
     */
    public static final String JODA_TIME_ZONE_ID = DateTimeZone.getDefault().getID();

    /**
     * 系统时区Name：GMT+08:00
     */
    public static final String ZONE_NAME = ZoneId.systemDefault().getId();
    /**
     * 系统时区ID：GMT+08:00
     */
    public static final ZoneId ZONE_ID = ZoneId.systemDefault();
    /**
     * 系统时区：GMT+08:00
     */
    public static final TimeZone ZONE = TimeZone.getDefault();

    /**
     * 一天的小时数
     */
    public static final int HOURS_OF_DAY = 24;
    /**
     * 一小时的分钟数
     */
    public static final int MINUTES_OF_HOUR = 60;
    /**
     * 一天的分钟数
     */
    public static final int MINUTES_OF_DAY = MINUTES_OF_HOUR * HOURS_OF_DAY;
    /**
     * 一分钟的秒数
     */
    public static final int SECONDS_OF_MINUTE = 60;
    /**
     * 一小时的秒数
     */
    static final int SECONDS_OF_HOUR = SECONDS_OF_MINUTE * MINUTES_OF_HOUR;
    /**
     * 一天的秒数
     */
    static final int SECONDS_OF_DAY = SECONDS_OF_HOUR * HOURS_OF_DAY;
    /**
     * 一秒的毫秒数
     */
    public static final int MILLIS_OF_SECOND = 1000;
    /**
     * 一分钟的毫秒数
     */
    public static final int MILLIS_OF_MINUTE = MILLIS_OF_SECOND * SECONDS_OF_MINUTE;
    /**
     * 一小时的毫秒数
     */
    public static final int MILLIS_OF_HOUR = MILLIS_OF_SECOND * SECONDS_OF_HOUR;
    /**
     * 一天的毫秒数
     */
    public static final int MILLIS_OF_DAY = MILLIS_OF_SECOND * SECONDS_OF_DAY;

    /**
     * Date格式：yyyy-MM-dd
     */
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    /**
     * Date格式：y年M月d日
     */
    public static final String DATE_PATTERN_ZH = "y年M月d日";
    /**
     * Date格式：yyyy-MM
     *
     * 注意：年+月不能转换日期，必须有日
     */
    public static final String MONTH_PATTERN = "yyyy-MM";
    /**
     * Date格式：y年M月
     *
     * 注意：年+月不能转换日期，必须有日
     */
    public static final String MONTH_PATTERN_ZH = "y年M月";
    /**
     * Date格式：yyyyMMdd
     */
    public static final String DATE_PATTERN_NUM = "yyyyMMdd";
    /**
     * Date格式：yyyyMM
     */
    public static final String MONTH_PATTERN_NUM = "yyyyMM";
    /**
     * Time格式：HH:mm:ss
     */
    public static final String TIME_PATTERN = "HH:mm:ss";
    /**
     * Time格式：HH时mm分ss秒
     */
    public static final String TIME_PATTERN_ZH = "HH时mm分ss秒";
    /**
     * Time格式：HHmmss
     */
    public static final String TIME_PATTERN_NUM = "HHmmss";
    /**
     * DateTime格式：yyyy-MM-dd HH
     */
    public static final String DATE_HOUR_PATTERN = "yyyy-MM-dd HH";
    /**
     * DateTime格式：yyyy年MM月dd日 HH时mm分ss秒
     */
    public static final String DATE_TIME_PATTERN_ZH = "yyyy年MM月dd日 HH时mm分ss秒";
    /**
     * DateTime格式：yyyy-MM-dd HH:mm:ss
     */
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    /**
     * DateTime格式：yyyyMMddHHmmss
     */
    public static final String DATE_TIME_PATTERN_NUM = "yyyyMMddHHmmss";

    /**
     * LocalDate格式：yyyy-MM-dd
     */
    public static final DateTimeFormatter DATE_FROMAT = DateTimeFormatter.ofPattern(DATE_PATTERN);
    /**
     * LocalDate格式：y年M月d日
     */
    public static final DateTimeFormatter DATE_FROMAT_ZH = DateTimeFormatter.ofPattern(DATE_PATTERN_ZH);
    /**
     * LocalDate格式：yyyyMMdd
     */
    public static final DateTimeFormatter DATE_FROMAT_NUM = DateTimeFormatter.ofPattern(DATE_PATTERN_NUM);
    /**
     * LocalDate格式：yyyy-MM
     */
    public static final DateTimeFormatter MONTH_FROMAT = DateTimeFormatter.ofPattern(MONTH_PATTERN);
    /**
     * LocalDate格式：y年M月
     */
    public static final DateTimeFormatter MONTH_FROMAT_ZH = DateTimeFormatter.ofPattern(MONTH_PATTERN_ZH);
    /**
     * LocalDate格式：yyyyMM
     */
    public static final DateTimeFormatter MONTH_FROMAT_NUM = DateTimeFormatter.ofPattern(MONTH_PATTERN_NUM);
    /**
     * LocalTime格式：HH时mm分ss秒
     */
    public static final DateTimeFormatter TIME_FROMAT_ZH = DateTimeFormatter.ofPattern(TIME_PATTERN_ZH);
    /**
     * LocalTime格式：HH:mm:ss
     */
    public static final DateTimeFormatter TIME_FROMAT = DateTimeFormatter.ofPattern(TIME_PATTERN);
    /**
     * LocalTime格式：HHmmss
     */
    public static final DateTimeFormatter TIME_FROMAT_NUM = DateTimeFormatter.ofPattern(TIME_PATTERN_NUM);
    /**
     * LocalDateTime格式：yyyy-MM-dd HH
     */
    public static final DateTimeFormatter DATE_HOUR_FROMAT = DateTimeFormatter.ofPattern(DATE_HOUR_PATTERN);
    /**
     * LocalDateTime格式：yyyy年MM月dd日 HH时mm分ss秒
     */
    public static final DateTimeFormatter DATE_TIME_FROMAT_ZH = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN_ZH);
    /**
     * LocalDateTime格式：yyyy-MM-dd HH:mm:ss
     */
    public static final DateTimeFormatter DATE_TIME_FROMAT = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
    /**
     * LocalDateTime格式：yyyyMMddHHmmss
     */
    public static final DateTimeFormatter DATE_TIME_FROMAT_NUM = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN_NUM);

}
