package cn.dolphin.core.consts;

import java.util.regex.Pattern;

/**
 * 基础常量
 */
public class Constants {

    /** 逗号分割 */
    public static final Pattern COMMA_SPLIT_PATTERN = Pattern.compile("\\s*[,]+\\s*");
    /** 分号分割 */
    public static final Pattern SEMICOLON_SPLIT_PATTERN = Pattern.compile("\\s*[;]+\\s*");
    /** 默认编码 */
    public static final String DEFAULT_CHARACTER = "UTF-8";
    /** 默认值毫秒，避免重新计算. */
    public static final int DEFAULT_SERVER_SHUTDOWN_TIMEOUT = 10000;
    /** 任意地址 */
    public static final String ANYHOST_VALUE = "0.0.0.0";

    public static final String REGISTRY_PROTOCOL_LOCAL = "local";
    public static final String REGISTRY_PROTOCOL_DIRECT = "direct";
    public static final int DEFAULT_INT_VALUE = 0;

    /** The constant APP_KEY. */
    public static final String APP_KEY = "appKey";
    /** he constant SIGN. */
    public static final String SIGN = "sign";


    /** ZK注册中心常量，用于rpc接口使用*/
    public static final int ZK_SESSION_TIMEOUT = 12000;
    public static final String ZK_REGISTRY_ROOT_PATH = "/registry";
    public static final String ZK_DATA_PATH = ZK_REGISTRY_ROOT_PATH + "/data";


    /** 分页信息*/
    public static final String PAGE_NUM = "page";//当前记录起始索引
    public static final String PAGE_SIZE = "pageSize";//每页显示记录数
    public static final String ORDER_BY_COLUMN = "orderByColumn";//排序列
    public static final String IS_ASC = "isAsc";//排序的方向 "desc" 或者 "asc"



}
