package cn.dolphin.core.cache.map.support;

import cn.dolphin.core.cache.map.ICache;
import cn.dolphin.core.cache.map.CacheManager;
import cn.dolphin.core.cache.map.impl.ConcurrentMapCache;
import org.springframework.beans.factory.InitializingBean;

public class SimpleCacheManager implements InitializingBean, CacheManager {

    private ICache cache;

    /**
     * Specify the Cache instances to use for this CacheManager.
     */
    public void setCache(ICache cache) {
        this.cache = cache;
    }

    public ICache getCache() {
        return cache;
    }



    @Override
    public void afterPropertiesSet() throws Exception {
        if(cache == null){
            cache = new ConcurrentMapCache();
        }
    }

}
