package cn.dolphin.core.cache.map;


/**
 *  可选，缓存默认实现，集群时建议使用分布式缓存自定义实现
 *     <bean id="dalCache" class="cn.dolphin.core.cache.map.impl.ConcurrentMapCache"></bean>
 *  配置缓存
 * 	<bean id="cacheManager" class="cn.dolphin.core.cache.map.support.SimpleCacheManager">
 * 		<property name="cache" ref="dalCache"></property>
 * 	</bean>
 */
public interface ICache {

    int getSize();

    void putObject(Object key, Object value);

    void putObject(Object key, Object value, int seconds);

    Object getObject(Object key);

    Object removeObject(Object key);

    void clear(String id);

}
