package cn.dolphin.core.cache.ehcache;

import java.util.List;
import java.util.Map;

/**
 * 使用默认的ONE_DAY,一天缓存
 *
 */
public class CacheUtils {
    private static CacheHelper cache;

    protected static CacheHelper getCache() {
        if (cache == null) {
            cache = CacheHelper.getCache("ONE_DAY");
        }
        return cache;
    }

    public static boolean put(Object key, Object value) {
        return getCache().put(key, value);
    }

    public static <T> T get(Object key) {
        return getCache().get(key);
    }

    public static String getString(Object key) {
        return (String) getCache().get(key);
    }

    public static Map getMap(Object key) {
        return getCache().get(key);
    }

    public static <T> List<T> getList(Object key) {
        return getCache().get(key);
    }

    public static int getInt(Object key) {
        Object o = getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (int) o;
    }

    public static short getShort(Object key) {
        Object o = getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (short) o;
    }

    public static long getLong(Object key) {
        Object o = getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (long) o;
    }

    public static float getFloat(Object key) {
        Object o = getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (float) o;
    }

    public static double getDouble(Object key) {
        Object o = getCache().get(key);
        if (o == null) {
            return -1;
        }
        return (double) o;
    }

    public static byte[] getBytes(Object key) {
        return (byte[]) getCache().get(key);
    }

    public static Byte getByte(Object key) {
        return (Byte) getCache().get(key);
    }

    public static int[] getIntArray(Object key) {
        return (int[]) getCache().get(key);
    }

    public static <T> T[] getArray(Object key, Class<T> clazz) {
        return getCache().get(key);
    }

    public static boolean exists(Object key) {
        return getCache().exists(key);
    }

    public static boolean remove(String key) {
        return getCache().remove(key);
    }

    public static List getKeys() {
        return getCache().getKeys();
    }
}
