package cn.dolphin.core.bean;

/**
 * 分页指示器，
 * 和数组一样，total为30，实际指的是0-29
 * 从0开始计数，如果需要统计的量从1开始，total值要加一
 * 每一个区间左闭右开，例:
 * 		区间长度为count=10，第一个区间为0-10，position=0，target=10，target所记录的值不在此区间中
 *
 */
public class Indicator {
    private long start;
    private long total;
    private long limit;

    private long part;
    private long lastPart;

    private long current;
    private long position;
    private long count;
    private long target;

    /**
     * 要处理的片段
     */
    public Indicator start(long start) {
        this.start = start;
        return this;
    }

    /**
     * 开始处理的位置
     */
    public Indicator total(long total) {
        this.total = total;
        return this;
    }

    /**
     * 每次要处理的片段长度
     */
    public Indicator limit(long limit) {
        if (limit <= 0)
            throw new ArithmeticException("below 0");
        this.limit = limit;
        return this;
    }

    /**
     * 所有的参数设置结束
     */
    public Indicator ok() {
        total -= start;
        part = (long) Math.ceil((double) total / (double) limit);
        lastPart = total - (part - 1) * limit;
        target += start;
        return this;
    }

    /**
     * 是否有下一个元素
     */
    public boolean hasNext() {
        return current < part;
    }

    /**
     * 下一个要处理的片段长度
     */
    public long next() {
        current++;
        count = current == part ? lastPart : limit;
        target = target + count;
        position = target - count;
        return count;
    }

    /**
     * 开始位置
     */
    public long position() {
        return this.position;
    }

    /**
     * 本次要处理的长度
     */
    public long count() {
        return this.count;
    }

    /**
     * 目标位置
     */
    public long target() {
        return target;
    }

    public static void main(String[] args) {
        Indicator indicator = new Indicator().start(3).total(10).limit(3).ok();
        while (indicator.hasNext()) {
            indicator.next();
            System.out.println("片段总数：" + indicator.count());
            System.out.println("开始位置：" + indicator.position());
            System.out.println("结尾位置：" + indicator.target());
            System.out.println("------------------------------");
        }
    }
}
