package cn.dolphin.core.bean;

import java.io.Serializable;

/**
 * 缓存性能监控指标信息
 */
public class EhcacheStatistic implements Serializable {

    private static final long serialVersionUID = -1441032853007404353L;

    //内存资源消耗(对象个数)
    private long memoryStoreSize = 0;
    //内存资源消耗(内存总量/MB)
    private double memoryStoreSizeInMB = 0;
    //磁盘资源消耗(对象个数)
    private long diskStoreSize = 0;
    //磁盘资源消耗(磁盘总量/MB)
    private double diskStoreSizeInMB = 0;
    //命中数
    private long hitCount = 0;
    //非命中数
    private long missCount = 0;
    //缓存数据总量
    private long size = 0;

    public EhcacheStatistic() {
        super();
    }

    public long getMemoryStoreSize() {
        return memoryStoreSize;
    }

    public void setMemoryStoreSize(long memoryStoreSize) {
        this.memoryStoreSize = memoryStoreSize;
    }

    public long getDiskStoreSize() {
        return diskStoreSize;
    }

    public void setDiskStoreSize(long diskStoreSize) {
        this.diskStoreSize = diskStoreSize;
    }

    public long getHitCount() {
        return hitCount;
    }

    public void setHitCount(long hitCount) {
        this.hitCount = hitCount;
    }

    public long getMissCount() {
        return missCount;
    }

    public void setMissCount(long missCount) {
        this.missCount = missCount;
    }

    public long getSize() {
        return size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public double getMemoryStoreSizeInMB() {
        return memoryStoreSizeInMB;
    }

    public void setMemoryStoreSizeInMB(double memoryStoreSizeInMB) {
        this.memoryStoreSizeInMB = memoryStoreSizeInMB;
    }

    public double getDiskStoreSizeInMB() {
        return diskStoreSizeInMB;
    }

    public void setDiskStoreSizeInMB(double diskStoreSizeInMB) {
        this.diskStoreSizeInMB = diskStoreSizeInMB;
    }
}
