package cn.dolphin.core.bean;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/**
 * 基类公共字段封装
 * 扩展map传递扩展属性参数
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
@SuppressWarnings("all")
public abstract class BaseModel <PK extends Serializable> implements Serializable {

    private static final long serialVersionUID = 4505412151396307777L;

    public BaseModel() {
    }

    /**
     * 编号
     * @return
     */
    public abstract PK getId();

    /**
     * 创建人ID
     */
    protected Long createdBy;
    /**
     * 创建时间
     */
    protected Timestamp createdAt;
    /**
     * 更新时间
     */
    protected Timestamp updatedAt;
    /**
     * 更新人ID
     */
    protected Long updatedBy;


    /** 请求参数 */
    protected Map<String, Object> paramsMap = new HashMap<String, Object>();

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }

    public Map<String, Object> getParamsMap() {
        if (paramsMap == null)
        {
            paramsMap = new HashMap<>();
        }
        return paramsMap;
    }

    public void setParamsMap(Map<String, Object> paramsMap) {
        this.paramsMap = paramsMap;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
