package cn.dolphin.core;

import cn.dolphin.core.id.ID;
import cn.dolphin.core.page.PageBean;
import cn.dolphin.core.page.PageSupport;
import cn.dolphin.core.util.*;
import lombok.experimental.UtilityClass;

import javax.annotation.Nullable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 工具包集合，工具类的快捷方式
 */
@UtilityClass
@SuppressWarnings("all")
public class $ {

    /**
     * ID
     * @return
     */
    public static long getID() {
        return ID.getID();
    }

    /**
     * 获取分页信息
     * @return
     */
    public static PageBean getPage() {
        PageBean pageBean = PageSupport.buildPageRequest();
        return pageBean;
    }

    /**
     * 判断对象是否为null
     */
    public static boolean isEmpty(@Nullable Object obj) {
        return EmptyUtil.isEmpty(obj);
    }

    /**
     * 判断对象是否 not null
     */
    public static boolean isNotEmpty(@Nullable Object obj) {
        return EmptyUtil.isNotEmpty(obj);
    }


    /**
     * 判断是否为空字符串
     * <pre class="code">
     * $.isBlank(null)		= true
     * $.isBlank("")		= true
     * $.isBlank(" ")		= true
     * $.isBlank("12345")	= false
     * $.isBlank(" 12345 ")	= false
     * </pre>
     */
    public static boolean isBlank(@Nullable final CharSequence cs) {
        return StrUtil.isBlank(cs);
    }

    /**
     * 判断不为空字符串
     * <pre>
     * $.isNotBlank(null)	= false
     * $.isNotBlank("")		= false
     * $.isNotBlank(" ")	= false
     * $.isNotBlank("bob")	= true
     * $.isNotBlank("  bob  ") = true
     * </pre>
     */
    public static boolean isNotBlank(@Nullable final CharSequence cs) {
        return StrUtil.isNotBlank(cs);
    }

    /**
     * 判断对象是数组
     *
     * @param obj the object to check
     * @return 是否数组
     */
    public static boolean isArray(@Nullable Object obj) {
        return ObjectUtil.isArray(obj);
    }

    /**
     * 判断数组为空
     *
     * @param array the array to check
     * @return 数组是否为空
     */
    public static boolean isArray(@Nullable Object[] array) {
        return ObjectUtil.isEmpty(array);
    }

    /**
     * 判断数组不为空
     *
     * @param array 数组
     * @return 数组是否不为空
     */
    public static boolean isNotArray(@Nullable Object[] array) {
        return ObjectUtil.isNotEmpty(array);
    }

    /**
     * 安全的 equals
     *
     * @param o1 first Object to compare
     * @param o2 second Object to compare
     * @return whether the given objects are equal
     */
    public static boolean equalsSafe(@Nullable Object o1, @Nullable Object o2) {
        return ObjectUtil.nullSafeEquals(o1, o2);
    }

    /**
     * 将已指定分隔符的字符串转为List
     * @param string	字符串
     * @param regex		分隔符
     * @return
     */
    public static List<String> toArray(String string, String regex) {
        return StrUtil.toArray(string,regex);
    }

    /**
     * List<String>转换String数组
     * @param list
     * @return
     */
    public static String[] toArray(List<String> list){
        return ListUtil.toArray(list);
    }

    /**
     * 数组转集合
     * @param arrays
     * @return
     */
    public static List<String>  toArray(String[] arrays) {
        return ListUtil.toArray(arrays);
    }

    /**
     * Constructs an empty ArrayList.
     */
    public static <E> ArrayList<E> newArrayList() {
        return InstanceUtil.newArrayList();
    }

    /**
     * Constructs an empty HashMap.
     */
    public static <k, v> HashMap<k, v> newHashMap() {
        return InstanceUtil.newHashMap();
    }

    /**
     * Constructs an empty HashSet.
     */
    public static <E> HashSet<E> newHashSet() {
        return InstanceUtil.newHashSet();
    }

    /**
     * Constructs an empty Hashtable.
     */
    public static <k, v> Hashtable<k, v> newHashtable() {
        return InstanceUtil.newHashtable();
    }

    /**
     * Constructs an empty LinkedHashMap.
     */
    public static <k, v> LinkedHashMap<k, v> newLinkedHashMap() {
        return InstanceUtil.newLinkedHashMap();
    }

    /**
     * Constructs an empty LinkedHashSet.
     */
    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return InstanceUtil.newLinkedHashSet();
    }

    /**
     * Constructs an empty LinkedList.
     */
    public static <E> LinkedList<E> newLinkedList() {
        return InstanceUtil.newLinkedList();
    }

    /**
     * Constructs an empty TreeMap.
     */
    public static <k, v> TreeMap<k, v> newTreeMap() {
        return InstanceUtil.newTreeMap();
    }

    /**
     * Constructs an empty TreeSet.
     */
    public static <E> TreeSet<E> newTreeSet() {
        return InstanceUtil.newTreeSet();
    }

    /**
     * Constructs an empty Vector.
     */
    public static <E> Vector<E> newVector() {
        return InstanceUtil.newVector();
    }

    /**
     * Constructs an empty WeakHashMap.
     */
    public static <k, v> WeakHashMap<k, v> newWeakHashMap() {
        return InstanceUtil.newWeakHashMap();
    }

    /**
     * Constructs an empty HashMap.
     */
    public static <k, v> Map<k, v> newHashMap(k key, v value) {
        return InstanceUtil.newHashMap(key,value);
    }

    /**
     * Constructs an empty ConcurrentHashMap.
     */
    public static <k, v> ConcurrentHashMap<k, v> newConcurrentHashMap() {
        return InstanceUtil.newConcurrentHashMap();
    }

    /**
     * 元转换成分
     *
     * @param amount 金额
     * @return 分
     */
    public static int getMoney(float amount) {
        Float f = new Float(Math.round(amount * 100));
        int fen = f.intValue();
        return fen;
    }

    /**
     * 格式化金额
     *
     * @param style 格式
     * @param value 金额
     * @return 格式化后的金额
     */
    public static String getFormatAmount(String style, Double value) {
        DecimalFormat df = new DecimalFormat();
        df.applyPattern(style);
        return df.format(value);
    }

    /**
     * 去掉小数点后面的0，导入数据的时候用到
     *
     * @param val 值
     * @return 格式化的值
     */
    public static String formatNumber(String val) {
        // 去掉后面无用的零
        val = val.replaceAll("0+?$", "");
        // 如小数点后面全是零则去掉小数点
        val = val.replaceAll("[.]$", "");
        return val;
    }

    /**
     * 判断是否为yyyy-MM-DD格式的日期字符串
     *
     * @param dateStr 日期串
     * @return 是否
     */
    public static boolean checkDateFormat(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-DD");
        try {
            Date date = simpleDateFormat.parse(dateStr);
        } catch (ParseException e) {
            return false;
        }
        return true;
    }


    /**
     * 取字符除最后一位的子串，比如 aaa,bbb, 返回aaa,bbb，一般用在多个字段进行拼接，要去除最后一位
     *
     * @param str 字符串
     * @return string
     */
    public static String subTract(String str) {
        return StrUtil.subTract(str);
    }

    /**
     * 数组分割
     * StrUtil.join(null, *)               = null
     * StrUtil.join([], *)                 = ""
     * StrUtil.join([null], *)             = ""
     * StrUtil.join(["a", "b", "c"], ';')  = "a;b;c"
     * StrUtil.join(["a", "b", "c"], null) = "abc"
     * StrUtil.join([null, "", "a"], ';')  = ";;a"
     * @param array
     * @param separator
     * @return
     */
    public static String subArray(Object[] array, char separator){
        return StrUtil.join(array,separator);
    }


    /**
     * 判断一个字符串是否等于一个数组中的一个值
     * @param value
     * @param equalArr
     * @return
     */
    public static boolean isEqualsArr(Object value, Object ...equalArr){
        return StrUtil.isEqualsArr(value,equalArr);
    }

    /**
     * 判断一个字符串是否等于一个数组中的一个值[不区分大小写]
     * @param value
     * @param equalArr
     * @return
     */
    public static boolean isEqualsIcArr(Object value, Object ...equalArr) {
        return StrUtil.isEqualsIcArr(value,equalArr);
    }

    /**
     * 判断一个字符串是否不等于一个数组中的一个值
     * @param value
     * @param notEqualArr
     * @return
     */
    public static boolean isNotEqualsArr(Object value, Object ...notEqualArr){
        return StrUtil.isNotEqualsArr(value,notEqualArr);
    }

    /**
     * 判断一个字符串是否不等于一个数组中的一个值[不区分大小写]
     * @param value
     * @param notEqualArr
     * @return
     */
    public static boolean isNotEqualsIcArr(Object value, Object ...notEqualArr) {
        return StrUtil.isNotEqualsIcArr(value,notEqualArr);
    }

    /**
     * 判断字符串中是否包含http链接
     * @param str
     * @return
     */
    public static boolean existUrl(String str){
        return StrUtil.existUrl(str);
    }

    /**
     * 检查对象是否为数字型字符串。
     */
    public static boolean isNumeric(Object obj) {
        return StrUtil.isNumeric(obj);
    }


    /**
     * java将字符串转换成可执行代码 工具类
     * 使用commons的jexl可实现将字符串变成可执行代码的功能
     * @param jexlExp 字符串表达式
     * @param map 参数
     * @return
     */
    public static Object eval(String jexlExp, Map<String, Object> map){
        return Jexl3Util.convertToCode(jexlExp,map);
    }

}
