package cn.dolphin.codegen.util;

import cn.dolphin.codegen.model.Field;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.util.EmptyUtil;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DB {
    /**
     * 存储templateMap，起缓存作用
     */
    private static HashMap<String, JdbcTemplate> templateMap = new HashMap<String, JdbcTemplate>();

    /**
     * 默认Key
     */
    private static String jdbcTemplateKey = "jdbcTemplate";


    /**
     * 创建数据连接 Template
     *
     * @return JdbcTemplate
     */
    public static JdbcTemplate getJdbcTemplate(String driver,String jdbcurl,String username,String password) {

        if(MapUtil.isNotEmpty(templateMap)){
            if(EmptyUtil.isNotEmpty(MapUtil.getObject(templateMap,jdbcTemplateKey))){
                return MapUtil.getObject(templateMap,jdbcTemplateKey);
            }
        }

        //创建基础hikari数据源
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(driver);
        hikariConfig.setJdbcUrl(jdbcurl);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);

        hikariConfig.setMaximumPoolSize(5);
        hikariConfig.setConnectionTestQuery("SELECT 1");
        hikariConfig.setPoolName("codegen");
        hikariConfig.addDataSourceProperty("dataSource.cachePrepStmts", "true");
        hikariConfig.addDataSourceProperty("dataSource.prepStmtCacheSize", "250");
        hikariConfig.addDataSourceProperty("dataSource.prepStmtCacheSqlLimit", "2048");
        hikariConfig.addDataSourceProperty("dataSource.useServerPrepStmts", "true");
        HikariDataSource dataSource = new HikariDataSource(hikariConfig);
        JdbcTemplate template = new JdbcTemplate(dataSource);
        templateMap.put(jdbcTemplateKey, template);
        return template;
    }

    /**
     * 取JavaTypes
     *
     * @return Map
     */
    private static Map<String, String> getTypesJava() {
        Map<String, String> map = new HashMap<String, String>(20);
        map.put("VARCHAR", "String");
        map.put("CHAR", "String");
        map.put("BLOB", "byte[]");
        map.put("TEXT", "String");
        map.put("INTEGER", "Integer");
        map.put("INT", "Integer");
        map.put("SMALLINT", "Short");
        map.put("MEDIUMINT", "Integer");
        map.put("BIT", "Boolean");
        map.put("BIGINT", "Long");
        map.put("FLOAT", "Float");
        map.put("DOUBLE", "Double");
        map.put("DECIMAL", "BigDecimal");
        map.put("BOOLEAN", "Integer");
        //map.put("TINYINT", "Byte");
        map.put("TINYINT", "Integer");
        map.put("DATE", "Date");
        map.put("TIME", "Time");
        map.put("DATETIME", "Date");
        map.put("TIMESTAMP", "Timestamp");
        map.put("YEAR", "Date");
        return map;
    }

    /**
     * 取JdbcTypes
     *
     * @return Map
     */
    private static Map<String, String> getTypesJdbc() {
        Map<String, String> map = new HashMap<String, String>(20);
        map.put("VARCHAR", "VARCHAR");
        map.put("CHAR", "CHAR");
        map.put("BLOB", "BINARY");
        map.put("TEXT", "LONGVARCHAR");
        map.put("INTEGER", "INTEGER");
        map.put("INT", "INTEGER");
        map.put("SMALLINT", "SMALLINT");
        map.put("MEDIUMINT", "INTEGER");
        map.put("BIT", "BIT");
        map.put("BIGINT", "BIGINT");
        map.put("FLOAT", "REAL");
        map.put("DOUBLE", "DOUBLE");
        map.put("DECIMAL", "DECIMAL");
        map.put("TINYINT", "TINYINT");
        map.put("DATE", "DATE");
        map.put("TIME", "TIME");
        map.put("DATETIME", "TIMESTAMP");
        map.put("TIMESTAMP", "TIMESTAMP");
        map.put("YEAR", "DATE");
        return map;
    }


    /**
     * 获取字符串型的类型名
     *
     * @param type 类型
     * @return String
     */
    public static String convertToJavaType(String type) {
        Map<String, String> map = getTypesJava();
        if (map.containsKey(type)) {
            return map.get(type);
        } else {
            return "String";
        }
    }

    /**
     * 转换成JdbcType
     *
     * @param type 类型
     * @return String
     */
    public static String convertToJdbcType(String type) {
        Map<String, String> map = getTypesJdbc();
        if (map.containsKey(type)) {
            return map.get(type);
        } else {
            return "String";
        }
    }

    /**
     * 取表的主键
     *
     * @param fieldList 字段List
     * @return Field
     */
    public static Field getFieldPk(List<Field> fieldList) {
        Field field = new Field();
        for (Field item : fieldList) {
            if (item.getIsPk() == 1) {
                field = item;
                break;
            }
        }
        return field;
    }

}
