package cn.dolphin.codegen.service.impl;

import cn.dolphin.codegen.model.Field;
import cn.dolphin.codegen.model.Table;
import cn.dolphin.codegen.service.DataService;
import cn.dolphin.codegen.util.DB;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataServiceImpl implements DataService {

    /**
     * 根据表名获取模板要用的Map型数据
     * (带有列信息)
     *
     * @param table     表名
     * @param fieldList 字段List
     * @return Map
     */
    @Override
    public Map<String, Object> getDbTemplateData(Table table, List<Field> fieldList) {
        Map<String, Object> templateData = new HashMap<String, Object>(8);
        templateData.put("tableName", table.getName());
        templateData.put("tableProName", table.getProName());
        templateData.put("tableProNameUrl", table.getProNameUrl());
        templateData.put("tableDescription", table.getDescription());
        templateData.put("fieldList", fieldList);
        templateData.put("fieldPk", DB.getFieldPk(fieldList));
//        templateData.put("config", FreeMakerUtil.useStaticPackage("org.xx.model.Config"));
        return templateData;
    }


}
