package cn.dolphin.codegen.dao;

import cn.dolphin.codegen.model.Field;
import cn.dolphin.codegen.model.Table;
import cn.dolphin.codegen.util.DB;
import cn.dolphin.core.enums.SecurityEnum;
import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.util.CamelCaseUtil;
import cn.dolphin.core.util.ClassUtil;
import cn.dolphin.core.util.ListUtil;
import cn.dolphin.core.util.StrUtil;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.List;
@Data
@Accessors(chain = true)
public class DataDao {

    private JdbcTemplate jdbcTemplate;

    private String driver;

    private String jdbcurl;

    private String username;

    private String password;

    private String tableSchema;//库名

    private String tableName;//表名

    public DataDao() {
    }

    public DataDao(String driver, String jdbcurl, String username, String password) {
       this.driver = driver;
       this.jdbcurl = jdbcurl;
       this.username = username;
       this.password = password;
    }

    //查询dbName所有表
    private final String tableSql = "select table_name as name,table_comment as description from information_schema.tables where table_schema='%s' and table_name = '%s' ";

    //查询表属性,格式化生成实体所需属性
    private final String fildSql = "SELECT c.COLUMN_NAME as name,c.DATA_TYPE as type,IFNULL(c.CHARACTER_MAXIMUM_LENGTH,0) as maxLength,(CASE c.IS_NULLABLE WHEN 'NO' THEN 0 ELSE 1 END) as isNullable,(CASE WHEN t.AUTO_INCREMENT>0 AND k.COLUMN_NAME IS NOT NULL AND c.EXTRA='auto_increment' THEN 1 ELSE 0 END) as isIdentity,c.COLUMN_COMMENT as description,(CASE c.COLUMN_KEY WHEN 'PRI' THEN 1 ELSE 0 END) as isPk " +
            "FROM information_schema.COLUMNS AS c INNER JOIN information_schema.`TABLES` AS t ON t.TABLE_SCHEMA=c.TABLE_SCHEMA AND t.TABLE_NAME=c.TABLE_NAME  LEFT JOIN information_schema.KEY_COLUMN_USAGE k ON k.COLUMN_NAME=c.COLUMN_NAME AND c.TABLE_NAME=k.TABLE_NAME AND c.TABLE_SCHEMA=k.TABLE_SCHEMA WHERE c.TABLE_SCHEMA='%s' AND c.TABLE_NAME='%s'  ORDER BY c.ORDINAL_POSITION ASC";





    /**
     * 根据库名取所有表
     * @return 表List
     */
    public Table getTables(Class<?> clazz) {
        try {
            jdbcTemplate = DB.getJdbcTemplate(driver,jdbcurl,username,password);
            String sql = String.format(tableSql, tableSchema,tableName);
            List<Table> tableList = jdbcTemplate.query(sql, new BeanPropertyRowMapper(Table.class));
            tableList.forEach(table -> {
//                table.setProName(CamelCaseUtil.toCapitalizeCamelCase(table.getName()));
                table.setProName(ClassUtil.getClassName(clazz));
                table.setProNameUrl(ClassUtil.getClass(clazz));

                table.setDescription(StrUtil.toDefault(table.getDescription(), ""));
            });
            if(ListUtil.isEmpty(tableList)){
                throw  new ApiException(SecurityEnum.API_000006.code(),"指定的表名未找到！");
            }
            return tableList.get(0);
        } catch (Exception e) {
            throw  new ApiException(e.getMessage(),e);
        }

    }



    /**
     * 根据表名获取所有的列信息
     * @return 字段List
     */
    public List<Field> getAllColums() {
        try {
            jdbcTemplate = DB.getJdbcTemplate(driver,jdbcurl,username,password);
            String sql = String.format(fildSql, tableSchema, tableName);
            List<Field> fieldList = jdbcTemplate.query(sql, new BeanPropertyRowMapper(Field.class));
            fieldList.forEach(field -> {
                field.setProName(CamelCaseUtil.toCamelCase(field.getName()));
                String fieldType = field.getType().toUpperCase();
                String javaType = DB.convertToJavaType(fieldType);
                field.setType(javaType);
                field.setJdbcType(DB.convertToJdbcType(fieldType));
                field.setDescription(StrUtil.toDefault(field.getDescription(), ""));
            });
            if(ListUtil.isEmpty(fieldList)){
                throw  new ApiException(SecurityEnum.API_000006.code(),"表名获取所有的列信息获取异常！");
            }
            return fieldList;
        } catch (Exception e) {
            throw  new ApiException(e.getMessage(),e);
        }
    }

    public static void main(String[] args) {
        DataDao dataDao = new DataDao();
        dataDao.setDriver("com.mysql.cj.jdbc.Driver")
               .setJdbcurl("jdbc:mysql://10.15.2.201:3306/ncai_email_2019?useUnicode=true&characterEncoding=utf-8&allowMultiQueries=true")
               .setUsername("root")
               .setPassword("9aHta4gDtPuk")
               .setTableSchema("ncai_email_2019")
               .setTableName("email_send_log");
        System.out.println(dataDao.getAllColums());
    }



}
