package cn.dolphin.codegen;


import cn.dolphin.codegen.dao.DataDao;
import cn.dolphin.codegen.model.Field;
import cn.dolphin.codegen.model.Table;
import cn.dolphin.codegen.service.DataService;
import cn.dolphin.codegen.service.impl.DataServiceImpl;
import cn.dolphin.core.freemarker.FreemarkerUtil;
import cn.dolphin.core.map.MapUtil;
import cn.dolphin.core.util.CamelCaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;


/**
* 代码生成主类.
*/
public class CodeGen {

   private static final Logger logger = LoggerFactory.getLogger(CodeGen.class);

    /**
     * dataService
     */
    private static DataService dataService = new DataServiceImpl();

    private static DataDao dataDao = new DataDao();

    protected static void generateModel(Class<?> clazz){
        Table table = dataDao.getTables(clazz);
        List<Field> fieldList = dataDao.getAllColums();
        System.out.println("=====================================================================================================================");
        System.out.println("代码生成器｛模型生成｝Start");
        generateFile("ModelTemplate.ftl",table,fieldList,1);
    }

    protected static void generateDao(Class<?> clazz){
        Table table = dataDao.getTables(clazz);
        List<Field> fieldList = dataDao.getAllColums();
        System.out.println("代码生成器｛DAO生成｝Start");
        generateFile("DaoTemplate.ftl",table,fieldList,2);
    }

    protected static void generateMapper(Class<?> clazz){
        Table table = dataDao.getTables(clazz);
        List<Field> fieldList = dataDao.getAllColums();
        System.out.println("代码生成器｛Mapper.xml生成｝Start");
        generateFile("MapperTemplate.ftl",table,fieldList,3);
    }

    protected static void generateFile(String templateName, Table table,List<Field> fieldList,Integer type) {
        Map<String, Object> templateData = dataService.getDbTemplateData(table, fieldList);
        if(type==1){
            System.out.println("model名称："+ CamelCaseUtil.toCapitalizeCamelCase(MapUtil.getString(templateData,"tableProName","")));
        }else if(type==2){
            System.out.println("dao名称："+ CamelCaseUtil.toCapitalizeCamelCase(MapUtil.getString(templateData,"tableProName","")+"Dao"));
        }else if(type==3){
            System.out.println("mapper名称："+ CamelCaseUtil.toCapitalizeCamelCase(MapUtil.getString(templateData,"tableProName","")+"Dao.xml"));

        }

        String reult = FreemarkerUtil.generateString(templateName, "/codegen/template", templateData);
        System.out.println("=====================================================================================================================");
        System.out.println(reult);
        System.out.println("=====================================================================================================================");
    }


    /**
     * 代码生成工具
     * @param params
     *              ---driver 加载驱动类
     *              ---jdbcurl 数据库链接地址
     *              ---username 账号
     *              ---password 密码
     *              ---tableSchema 数据库名称
     *              ---tableName 表名称
     */
    public static void generate(Map<String,Object> params,Class<?> clazz) {

        dataDao.setDriver(MapUtil.getString(params,"driver",""))
                .setJdbcurl(MapUtil.getString(params,"jdbcurl",""))
                .setUsername(MapUtil.getString(params,"username",""))
                .setPassword(MapUtil.getString(params,"password",""))
                .setTableSchema(MapUtil.getString(params,"tableSchema",""))
                .setTableName(MapUtil.getString(params,"tableName",""));
        // 生成模型层
        CodeGen.generateModel(clazz);
        // 生成DAO层
        CodeGen.generateDao(clazz);
        // 生成Mapper层
        CodeGen.generateMapper(clazz);
        System.out.println("=====================================================================================================================");
    }

}
