/*
 * Decompiled with CFR 0.152.
 */
package zkclient.util;

import java.util.List;
import zkclient.ZookeeperClient;

public class ZookeeperPathUtil {
    public static String leadingZeros(long number, int numberOfLeadingZeros) {
        return String.format("%0" + numberOfLeadingZeros + "d", number);
    }

    public static String toString(ZookeeperClient zkClient) {
        return ZookeeperPathUtil.toString(zkClient, "/", PathFilter.ALL);
    }

    public static String toString(ZookeeperClient zkClient, String startPath, PathFilter pathFilter) {
        boolean level = true;
        StringBuilder builder = new StringBuilder("+ (" + startPath + ")");
        builder.append("\n");
        ZookeeperPathUtil.addChildrenToStringBuilder(zkClient, pathFilter, 1, builder, startPath);
        return builder.toString();
    }

    private static void addChildrenToStringBuilder(ZookeeperClient zkClient, PathFilter pathFilter, int level, StringBuilder builder, String startPath) {
        List<String> children = zkClient.getChildren(startPath);
        for (String node : children) {
            String nestedPath = startPath.endsWith("/") ? startPath + node : startPath + "/" + node;
            if (pathFilter.showChilds(nestedPath)) {
                builder.append(ZookeeperPathUtil.getSpaces(level - 1) + "'-+" + node + "\n");
                ZookeeperPathUtil.addChildrenToStringBuilder(zkClient, pathFilter, level + 1, builder, nestedPath);
                continue;
            }
            builder.append(ZookeeperPathUtil.getSpaces(level - 1) + "'--" + node + " (contents hidden)\n");
        }
    }

    private static String getSpaces(int level) {
        String s = "";
        for (int i = 0; i < level; ++i) {
            s = s + "  ";
        }
        return s;
    }

    public static interface PathFilter {
        public static final PathFilter ALL = new PathFilter(){

            @Override
            public boolean showChilds(String path) {
                return true;
            }
        };

        public boolean showChilds(String var1);
    }
}

