/*
 * Decompiled with CFR 0.152.
 */
package zkclient.exception;

import org.apache.zookeeper.KeeperException;
import zkclient.exception.ZkBadVersionException;
import zkclient.exception.ZkNoNodeException;
import zkclient.exception.ZkNodeExistsException;

public class ZkException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public ZkException() {
    }

    public ZkException(String message, Throwable cause) {
        super(message, cause);
    }

    public ZkException(String message) {
        super(message);
    }

    public ZkException(Throwable cause) {
        super(cause);
    }

    public static ZkException create(KeeperException e) {
        switch (e.code()) {
            case NONODE: {
                return new ZkNoNodeException(e);
            }
            case BADVERSION: {
                return new ZkBadVersionException(e);
            }
            case NODEEXISTS: {
                return new ZkNodeExistsException(e);
            }
        }
        return new ZkException(e);
    }
}

