/*
 * Decompiled with CFR 0.152.
 */
package zkclient;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zkclient.exception.ZkInterruptedException;

class ZookeeperEventThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperEventThread.class);
    private BlockingQueue<ZkEvent> events = new LinkedBlockingQueue<ZkEvent>();
    private static AtomicInteger EVENTID = new AtomicInteger(0);

    ZookeeperEventThread(String name) {
        this.setDaemon(true);
        this.setName("ZkClient-EventThread-" + this.getId() + "-" + name);
    }

    @Override
    public void run() {
        LOG.info("Starting ZkClient event thread.");
        try {
            while (!this.isInterrupted()) {
                ZkEvent zkEvent = this.events.take();
                int eventId = EVENTID.incrementAndGet();
                LOG.debug("Delivering event #" + eventId + " " + zkEvent);
                try {
                    zkEvent.run();
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    this.interrupt();
                }
                catch (Throwable e) {
                    LOG.error("Error handling event " + zkEvent, e);
                }
                LOG.debug("Delivering event #" + eventId + " done");
            }
        }
        catch (InterruptedException e) {
            LOG.info("Terminate ZkClient event thread.");
        }
    }

    public void send(ZkEvent event) {
        if (!this.isInterrupted()) {
            LOG.debug("New event: " + event);
            this.events.add(event);
        }
    }

    static abstract class ZkEvent {
        private String description;

        public ZkEvent(String description) {
            this.description = description;
        }

        public abstract void run() throws Exception;

        public String toString() {
            return "ZkEvent[" + this.description + "]";
        }
    }
}

