/*
 * Decompiled with CFR 0.152.
 */
package zkclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ConnectStringParser;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zkclient.IZookeeperConnection;
import zkclient.exception.ZkException;

public class ZookeeperConnection
implements IZookeeperConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperConnection.class);
    private static final int DEFAULT_SESSION_TIMEOUT = 50000;
    private ZooKeeper zk = null;
    private Lock zookeeperLock = new ReentrantLock();
    private final String servers;
    private String resolvedServers;
    private final int sessionTimeOut;

    public ZookeeperConnection(String zkServers) {
        this(zkServers, 50000);
    }

    public ZookeeperConnection(String zkServers, int sessionTimeOut) {
        this.servers = zkServers;
        this.sessionTimeOut = sessionTimeOut;
    }

    @Override
    public void connect(Watcher watcher) {
        this.zookeeperLock.lock();
        try {
            if (this.zk != null) {
                throw new IllegalStateException("zk client has already been started");
            }
            try {
                LOG.debug("Resolving hosts from configured hosts " + this.servers);
                this.resolvedServers = this.resolveHosts();
                LOG.debug("Creating new ZookKeeper instance to connect to resolved hosts " + this.resolvedServers + ".");
                System.setProperty("zookeeper.sasl.client", "false");
                this.zk = new ZooKeeper(this.resolvedServers, this.sessionTimeOut, watcher);
            }
            catch (IOException e) {
                throw new ZkException("Unable to connect to " + this.resolvedServers, e);
            }
        }
        finally {
            this.zookeeperLock.unlock();
        }
    }

    @Override
    public void close() throws InterruptedException {
        this.zookeeperLock.lock();
        try {
            if (this.zk != null) {
                LOG.debug("Closing ZooKeeper connected to " + this.servers);
                this.zk.close();
                this.zk = null;
            }
        }
        finally {
            this.zookeeperLock.unlock();
        }
    }

    @Override
    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this.zk.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws KeeperException, InterruptedException {
        return this.zk.create(path, data, acl, mode);
    }

    @Override
    public void delete(String path) throws InterruptedException, KeeperException {
        this.zk.delete(path, -1);
    }

    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.zk.delete(path, version);
    }

    @Override
    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.zk.exists(path, watch) != null;
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.zk.getChildren(path, watch);
    }

    @Override
    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        return this.zk.getData(path, watch, stat);
    }

    public void writeData(String path, byte[] data) throws KeeperException, InterruptedException {
        this.writeData(path, data, -1);
    }

    @Override
    public void writeData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        this.zk.setData(path, data, version);
    }

    @Override
    public Stat writeDataReturnStat(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.zk.setData(path, data, version);
    }

    @Override
    public ZooKeeper.States getZookeeperState() {
        return this.zk != null ? this.zk.getState() : null;
    }

    public ZooKeeper getZookeeper() {
        return this.zk;
    }

    @Override
    public long getCreateTime(String path) throws KeeperException, InterruptedException {
        Stat stat = this.zk.exists(path, false);
        if (stat != null) {
            return stat.getCtime();
        }
        return -1L;
    }

    @Override
    public String getServers() {
        return this.servers;
    }

    @Override
    public String getResolvedServers() {
        return this.resolvedServers;
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) throws KeeperException, InterruptedException {
        return this.zk.multi(ops);
    }

    @Override
    public void addAuthInfo(String scheme, byte[] auth) {
        this.zk.addAuthInfo(scheme, auth);
    }

    @Override
    public void setAcl(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        this.zk.setACL(path, acl, version);
    }

    @Override
    public Map.Entry<List<ACL>, Stat> getAcl(String path) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        List acl = this.zk.getACL(path, stat);
        return new AbstractMap.SimpleEntry<List<ACL>, Stat>(acl, stat);
    }

    private String resolveHosts() {
        ConnectStringParser connectStringParser = new ConnectStringParser(this.servers);
        ArrayList serverAddresses = connectStringParser.getServerAddresses();
        ArrayList<String> resolvedHosts = new ArrayList<String>();
        for (InetSocketAddress address : serverAddresses) {
            try {
                InetAddress ia = address.getAddress();
                String addr = ia != null ? ia.getHostAddress() : address.getHostString();
                InetAddress.getAllByName(addr);
                resolvedHosts.add(address.getHostString() + ":" + address.getPort());
            }
            catch (UnknownHostException ex) {
                LOG.warn("No IP address found for server: {}", (Object)address, (Object)ex);
            }
        }
        String resolvedConnectionString = String.join((CharSequence)",", resolvedHosts);
        if (connectStringParser.getChrootPath() != null) {
            resolvedConnectionString = resolvedConnectionString + connectStringParser.getChrootPath();
        }
        return resolvedConnectionString;
    }
}

