/*
 * Decompiled with CFR 0.152.
 */
package zkclient;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zkclient.DataUpdater;
import zkclient.IZookeeperConnection;
import zkclient.ZookeeperConnection;
import zkclient.ZookeeperEventThread;
import zkclient.ZookeeperLock;
import zkclient.exception.ZkAuthFailedException;
import zkclient.exception.ZkBadVersionException;
import zkclient.exception.ZkException;
import zkclient.exception.ZkInterruptedException;
import zkclient.exception.ZkNoNodeException;
import zkclient.exception.ZkNodeExistsException;
import zkclient.exception.ZkTimeoutException;
import zkclient.listener.IZookeeperChildListener;
import zkclient.listener.IZookeeperDataListener;
import zkclient.listener.IZookeeperStateListener;
import zkclient.serializer.JavaSerializer;
import zkclient.serializer.ZookeeperSerializer;
import zkclient.util.ExceptionUtil;
import zkclient.util.ZookeeperPathUtil;

public class ZookeeperClient
implements Watcher {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperClient.class);
    protected static final String JAVA_LOGIN_CONFIG_PARAM = "java.security.auth.login.config";
    protected static final String ZK_SASL_CLIENT = "zookeeper.sasl.client";
    protected static final String ZK_LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";
    protected static final TimeUnit DEFAULT_TIMEUNIT = TimeUnit.MILLISECONDS;
    protected static ZookeeperSerializer DEFAULT_ZOOKEEPERSERIALIZER = new JavaSerializer();
    protected final IZookeeperConnection connection;
    protected final long operationRetryTimeoutInMillis;
    private final Map<String, Set<IZookeeperChildListener>> childListener = new ConcurrentHashMap<String, Set<IZookeeperChildListener>>();
    private final ConcurrentHashMap<String, Set<IZookeeperDataListener>> dataListener = new ConcurrentHashMap();
    private final Set<IZookeeperStateListener> stateListener = new CopyOnWriteArraySet<IZookeeperStateListener>();
    private Watcher.Event.KeeperState currentState;
    private final ZookeeperLock zkEventLock = new ZookeeperLock();
    private boolean shutdownTriggered;
    private ZookeeperEventThread eventThread;
    private Thread zookeeperEventThread;
    private ZookeeperSerializer zkSerializer;
    private volatile boolean closed;
    private boolean isZkSaslEnabled;

    public ZookeeperClient(String serverstring) {
        this(serverstring, Integer.MAX_VALUE);
    }

    public ZookeeperClient(String zkServers, long connectionTimeout) {
        this(new ZookeeperConnection(zkServers), connectionTimeout);
    }

    public ZookeeperClient(String zkServers, long connectionTimeout, TimeUnit connectionTimeoutTimeUnit) {
        this((IZookeeperConnection)new ZookeeperConnection(zkServers), connectionTimeout, connectionTimeoutTimeUnit);
    }

    public ZookeeperClient(String zkServers, int sessionTimeout, long connectionTimeout) {
        this(new ZookeeperConnection(zkServers, sessionTimeout), connectionTimeout);
    }

    public ZookeeperClient(String zkServers, int sessionTimeout, long connectionTimeout, TimeUnit connectionTimeoutTimeUnit) {
        this((IZookeeperConnection)new ZookeeperConnection(zkServers, sessionTimeout), connectionTimeout, connectionTimeoutTimeUnit);
    }

    public ZookeeperClient(String zkServers, int sessionTimeout, long connectionTimeout, ZookeeperSerializer zkSerializer) {
        this((IZookeeperConnection)new ZookeeperConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    public ZookeeperClient(String zkServers, int sessionTimeout, long connectionTimeout, ZookeeperSerializer zkSerializer, TimeUnit connectionTimeoutTimeUnit) {
        this((IZookeeperConnection)new ZookeeperConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer, connectionTimeoutTimeUnit);
    }

    public ZookeeperClient(String zkServers, int sessionTimeout, long connectionTimeout, ZookeeperSerializer zkSerializer, long operationRetryTimeout) {
        this((IZookeeperConnection)new ZookeeperConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer, operationRetryTimeout);
    }

    public ZookeeperClient(IZookeeperConnection connection) {
        this(connection, Integer.MAX_VALUE);
    }

    public ZookeeperClient(IZookeeperConnection connection, long connectionTimeout) {
        this(connection, connectionTimeout, DEFAULT_ZOOKEEPERSERIALIZER);
    }

    public ZookeeperClient(IZookeeperConnection connection, long connectionTimeout, TimeUnit connectionTimeoutTimeUnit) {
        this(connection, connectionTimeout, DEFAULT_ZOOKEEPERSERIALIZER, connectionTimeoutTimeUnit);
    }

    public ZookeeperClient(IZookeeperConnection zkConnection, long connectionTimeout, ZookeeperSerializer zkSerializer) {
        this(zkConnection, connectionTimeout, zkSerializer, -1L);
    }

    public ZookeeperClient(IZookeeperConnection zkConnection, long connectionTimeout, ZookeeperSerializer zkSerializer, TimeUnit connectionTimeoutTimeUnit) {
        this(zkConnection, connectionTimeout, zkSerializer, -1L, connectionTimeoutTimeUnit);
    }

    public ZookeeperClient(IZookeeperConnection zkConnection, long connectionTimeout, ZookeeperSerializer zkSerializer, long operationRetryTimeout) {
        this(zkConnection, connectionTimeout, zkSerializer, operationRetryTimeout, DEFAULT_TIMEUNIT);
    }

    public ZookeeperClient(IZookeeperConnection zkConnection, long connectionTimeout, ZookeeperSerializer zkSerializer, long operationRetryTimeout, TimeUnit connectionTimeoutTimeUnit) {
        if (zkConnection == null) {
            throw new NullPointerException("Zookeeper connection is null!");
        }
        this.connection = zkConnection;
        this.zkSerializer = zkSerializer;
        this.operationRetryTimeoutInMillis = operationRetryTimeout;
        this.isZkSaslEnabled = this.isZkSaslEnabled();
        this.connect(connectionTimeout, connectionTimeoutTimeUnit, this);
    }

    public void setZkSerializer(ZookeeperSerializer zkSerializer) {
        this.zkSerializer = zkSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> subscribeChildChanges(String path, IZookeeperChildListener listener) {
        Map<String, Set<IZookeeperChildListener>> map = this.childListener;
        synchronized (map) {
            Set<IZookeeperChildListener> listeners = this.childListener.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<IZookeeperChildListener>();
                this.childListener.put(path, listeners);
            }
            listeners.add(listener);
        }
        return this.watchForChilds(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeChildChanges(String path, IZookeeperChildListener childListener) {
        IZookeeperChildListener iZookeeperChildListener = childListener;
        synchronized (iZookeeperChildListener) {
            Set<IZookeeperChildListener> listeners = this.childListener.get(path);
            if (listeners != null) {
                listeners.remove(childListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeDataChanges(String path, IZookeeperDataListener listener) {
        ConcurrentHashMap<String, Set<IZookeeperDataListener>> concurrentHashMap = this.dataListener;
        synchronized (concurrentHashMap) {
            Set<IZookeeperDataListener> listeners = this.dataListener.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<IZookeeperDataListener>();
                this.dataListener.put(path, listeners);
            }
            listeners.add(listener);
        }
        this.watchForData(path);
        LOG.debug("Subscribed data changes for " + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeDataChanges(String path, IZookeeperDataListener dataListener) {
        IZookeeperDataListener iZookeeperDataListener = dataListener;
        synchronized (iZookeeperDataListener) {
            Set<IZookeeperDataListener> listeners = this.dataListener.get(path);
            if (listeners != null) {
                listeners.remove(dataListener);
            }
            if (listeners == null || listeners.isEmpty()) {
                this.dataListener.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeStateChanges(IZookeeperStateListener listener) {
        Set<IZookeeperStateListener> set = this.stateListener;
        synchronized (set) {
            this.stateListener.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeStateChanges(IZookeeperStateListener stateListener) {
        IZookeeperStateListener iZookeeperStateListener = stateListener;
        synchronized (iZookeeperStateListener) {
            this.stateListener.remove(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeAll() {
        Object object = this.childListener;
        synchronized (object) {
            this.childListener.clear();
        }
        object = this.dataListener;
        synchronized (object) {
            this.dataListener.clear();
        }
        object = this.stateListener;
        synchronized (object) {
            this.stateListener.clear();
        }
    }

    public void createPersistent(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, false);
    }

    public void createPersistent(String path, boolean createParents) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.createPersistent(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    public void createPersistent(String path, boolean createParents, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        try {
            this.create(path, null, acl, CreateMode.PERSISTENT);
        }
        catch (ZkNodeExistsException e) {
            if (!createParents) {
                throw e;
            }
        }
        catch (ZkNoNodeException e) {
            if (!createParents) {
                throw e;
            }
            String parentDir = path.substring(0, path.lastIndexOf(47));
            this.createPersistent(parentDir, createParents, acl);
            this.createPersistent(path, createParents, acl);
        }
    }

    public void setAcl(final String path, final List<ACL> acl) throws ZkException {
        if (path == null) {
            throw new NullPointerException("Missing value for path");
        }
        if (acl == null || acl.size() == 0) {
            throw new NullPointerException("Missing value for ACL");
        }
        if (!this.exists(path)) {
            throw new RuntimeException("trying to set acls on non existing node " + path);
        }
        this.retryUntilConnected(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Stat stat = new Stat();
                ZookeeperClient.this.connection.readData(path, stat, false);
                ZookeeperClient.this.connection.setAcl(path, acl, stat.getAversion());
                return null;
            }
        });
    }

    public Map.Entry<List<ACL>, Stat> getAcl(final String path) throws ZkException {
        if (path == null) {
            throw new NullPointerException("Missing value for path");
        }
        if (!this.exists(path)) {
            throw new RuntimeException("trying to get acls on non existing node " + path);
        }
        return this.retryUntilConnected(new Callable<Map.Entry<List<ACL>, Stat>>(){

            @Override
            public Map.Entry<List<ACL>, Stat> call() throws Exception {
                return ZookeeperClient.this.connection.getAcl(path);
            }
        });
    }

    public void createPersistent(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.PERSISTENT);
    }

    public void createPersistent(String path, Object data, List<ACL> acl) {
        this.create(path, data, acl, CreateMode.PERSISTENT);
    }

    public String createPersistentSequential(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public String createPersistentSequential(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.PERSISTENT_SEQUENTIAL);
    }

    public void createEphemeral(String path) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, null, acl, CreateMode.EPHEMERAL);
    }

    public String create(String path, Object data, CreateMode mode) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public String create(final String path, Object data, final List<ACL> acl, final CreateMode mode) {
        if (path == null) {
            throw new NullPointerException("Missing value for path");
        }
        if (acl == null || acl.size() == 0) {
            throw new NullPointerException("Missing value for ACL");
        }
        final byte[] bytes = data == null ? null : this.serialize(data);
        return this.retryUntilConnected(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return ZookeeperClient.this.connection.create(path, bytes, acl, mode);
            }
        });
    }

    public void createEphemeral(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, CreateMode.EPHEMERAL);
    }

    public void createEphemeral(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        this.create(path, data, acl, CreateMode.EPHEMERAL);
    }

    public String createEphemeralSequential(String path, Object data) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    public String createEphemeralSequential(String path, Object data, List<ACL> acl) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        return this.create(path, data, acl, CreateMode.EPHEMERAL_SEQUENTIAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        LOG.debug("Received event: " + event);
        this.zookeeperEventThread = Thread.currentThread();
        boolean stateChanged = event.getPath() == null;
        boolean znodeChanged = event.getPath() != null;
        boolean dataChanged = event.getType() == Watcher.Event.EventType.NodeDataChanged || event.getType() == Watcher.Event.EventType.NodeDeleted || event.getType() == Watcher.Event.EventType.NodeCreated || event.getType() == Watcher.Event.EventType.NodeChildrenChanged;
        this.getEventLock().lock();
        try {
            if (this.getShutdownTrigger()) {
                LOG.debug("ignoring event '{" + event.getType() + " | " + event.getPath() + "}' since shutdown triggered");
                return;
            }
            if (stateChanged) {
                this.processStateChanged(event);
            }
            if (dataChanged) {
                this.processDataOrChildChange(event);
            }
        }
        finally {
            if (stateChanged) {
                this.getEventLock().getStateChangedCondition().signalAll();
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    this.getEventLock().getZNodeEventCondition().signalAll();
                    this.getEventLock().getDataChangedCondition().signalAll();
                    this.fireAllEvents();
                }
            }
            if (znodeChanged) {
                this.getEventLock().getZNodeEventCondition().signalAll();
            }
            if (dataChanged) {
                this.getEventLock().getDataChangedCondition().signalAll();
            }
            this.getEventLock().unlock();
            LOG.debug("Leaving process event");
        }
    }

    private void fireAllEvents() {
        for (Map.Entry<String, Set<IZookeeperChildListener>> entry : this.childListener.entrySet()) {
            this.fireChildChangedEvents(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Set<Object>> entry : this.dataListener.entrySet()) {
            this.fireDataChangedEvents(entry.getKey(), entry.getValue());
        }
    }

    public List<String> getChildren(String path) {
        return this.getChildren(path, this.hasListeners(path));
    }

    protected List<String> getChildren(final String path, final boolean watch) {
        return this.retryUntilConnected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return ZookeeperClient.this.connection.getChildren(path, watch);
            }
        });
    }

    public int countChildren(String path) {
        try {
            return this.getChildren(path).size();
        }
        catch (ZkNoNodeException e) {
            return 0;
        }
    }

    protected boolean exists(final String path, final boolean watch) {
        return this.retryUntilConnected(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ZookeeperClient.this.connection.exists(path, watch);
            }
        });
    }

    public boolean exists(String path) {
        return this.exists(path, this.hasListeners(path));
    }

    private void processStateChanged(WatchedEvent event) {
        LOG.info("zookeeper state changed (" + event.getState() + ")");
        this.setCurrentState(event.getState());
        if (this.getShutdownTrigger()) {
            return;
        }
        this.fireStateChangedEvent(event.getState());
        if (event.getState() == Watcher.Event.KeeperState.Expired) {
            try {
                this.reconnect();
                this.fireNewSessionEvents();
            }
            catch (Exception e) {
                LOG.info("Unable to re-establish connection. Notifying consumer of the following exception: ", (Throwable)e);
                this.fireSessionEstablishmentError(e);
            }
        }
    }

    private void fireNewSessionEvents() {
        for (final IZookeeperStateListener stateListener : this.stateListener) {
            this.eventThread.send(new ZookeeperEventThread.ZkEvent("New session event sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleNewSession();
                }
            });
        }
    }

    private void fireStateChangedEvent(final Watcher.Event.KeeperState state) {
        for (final IZookeeperStateListener stateListener : this.stateListener) {
            this.eventThread.send(new ZookeeperEventThread.ZkEvent("State changed to " + state + " sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleStateChanged(state);
                }
            });
        }
    }

    private void fireSessionEstablishmentError(final Throwable error) {
        for (final IZookeeperStateListener stateListener : this.stateListener) {
            this.eventThread.send(new ZookeeperEventThread.ZkEvent("Session establishment error(" + error + ") sent to " + stateListener){

                @Override
                public void run() throws Exception {
                    stateListener.handleSessionEstablishmentError(error);
                }
            });
        }
    }

    private boolean hasListeners(String path) {
        Set<IZookeeperDataListener> dataListeners = this.dataListener.get(path);
        if (dataListeners != null && dataListeners.size() > 0) {
            return true;
        }
        Set<IZookeeperChildListener> childListeners = this.childListener.get(path);
        return childListeners != null && childListeners.size() > 0;
    }

    public boolean deleteRecursive(String path) {
        List<String> children;
        try {
            children = this.getChildren(path, false);
        }
        catch (ZkNoNodeException e) {
            return true;
        }
        for (String subPath : children) {
            if (this.deleteRecursive(path + "/" + subPath)) continue;
            return false;
        }
        return this.delete(path);
    }

    private void processDataOrChildChange(WatchedEvent event) {
        Set<IZookeeperDataListener> listeners;
        Set<IZookeeperChildListener> childListeners;
        String path = event.getPath();
        if (!(event.getType() != Watcher.Event.EventType.NodeChildrenChanged && event.getType() != Watcher.Event.EventType.NodeCreated && event.getType() != Watcher.Event.EventType.NodeDeleted || (childListeners = this.childListener.get(path)) == null || childListeners.isEmpty())) {
            this.fireChildChangedEvents(path, childListeners);
        }
        if (!(event.getType() != Watcher.Event.EventType.NodeDataChanged && event.getType() != Watcher.Event.EventType.NodeDeleted && event.getType() != Watcher.Event.EventType.NodeCreated || (listeners = this.dataListener.get(path)) == null || listeners.isEmpty())) {
            this.fireDataChangedEvents(event.getPath(), listeners);
        }
    }

    private void fireDataChangedEvents(final String path, Set<IZookeeperDataListener> listeners) {
        for (final IZookeeperDataListener listener : listeners) {
            this.eventThread.send(new ZookeeperEventThread.ZkEvent("Data of " + path + " changed sent to " + listener){

                @Override
                public void run() throws Exception {
                    ZookeeperClient.this.exists(path, true);
                    try {
                        Object data = ZookeeperClient.this.readData(path, null, true);
                        listener.handleDataChange(path, data);
                    }
                    catch (ZkNoNodeException e) {
                        listener.handleDataDeleted(path);
                    }
                }
            });
        }
    }

    private void fireChildChangedEvents(final String path, Set<IZookeeperChildListener> childListeners) {
        try {
            for (final IZookeeperChildListener listener : childListeners) {
                this.eventThread.send(new ZookeeperEventThread.ZkEvent("Children of " + path + " changed sent to " + listener){

                    @Override
                    public void run() throws Exception {
                        try {
                            ZookeeperClient.this.exists(path);
                            List<String> children = ZookeeperClient.this.getChildren(path);
                            listener.listenChildChange(path, children);
                        }
                        catch (ZkNoNodeException e) {
                            listener.listenChildChange(path, null);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("Failed to fire child changed event. Unable to getChildren.  ", (Throwable)e);
        }
    }

    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) throws ZkInterruptedException {
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.debug("Waiting until znode '" + path + "' becomes available.");
        if (this.exists(path)) {
            return true;
        }
        this.acquireEventLock();
        try {
            boolean gotSignal;
            while (!this.exists(path, true)) {
                gotSignal = this.getEventLock().getZNodeEventCondition().awaitUntil(timeout);
                if (gotSignal) continue;
                boolean bl = false;
                return bl;
            }
            gotSignal = true;
            return gotSignal;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    protected Set<IZookeeperDataListener> getDataListener(String path) {
        return this.dataListener.get(path);
    }

    public void showFolders(OutputStream output) {
        try {
            output.write(ZookeeperPathUtil.toString(this).getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isZkSaslEnabled() {
        boolean isSecurityEnabled = false;
        boolean zkSaslEnabled = Boolean.parseBoolean(System.getProperty(ZK_SASL_CLIENT, "true"));
        String zkLoginContextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME_KEY, "Client");
        if (!zkSaslEnabled) {
            LOG.warn("Client SASL has been explicitly disabled with zookeeper.sasl.client");
            return false;
        }
        String loginConfigFile = System.getProperty(JAVA_LOGIN_CONFIG_PARAM);
        if (loginConfigFile != null && loginConfigFile.length() > 0) {
            LOG.info("JAAS File name: " + loginConfigFile);
            File configFile = new File(loginConfigFile);
            if (!configFile.canRead()) {
                throw new IllegalArgumentException("File " + loginConfigFile + "cannot be read.");
            }
            try {
                Configuration loginConf = Configuration.getConfiguration();
                isSecurityEnabled = loginConf.getAppConfigurationEntry(zkLoginContextName) != null;
            }
            catch (Exception e) {
                throw new ZkException(e);
            }
        }
        return isSecurityEnabled;
    }

    public void waitUntilConnected() throws ZkInterruptedException {
        this.waitUntilConnected(Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean waitUntilConnected(long time, TimeUnit timeUnit) throws ZkInterruptedException {
        if (this.isZkSaslEnabled) {
            return this.waitForKeeperState(Watcher.Event.KeeperState.SaslAuthenticated, time, timeUnit);
        }
        return this.waitForKeeperState(Watcher.Event.KeeperState.SyncConnected, time, timeUnit);
    }

    public boolean waitForKeeperState(Watcher.Event.KeeperState keeperState, long time, TimeUnit timeUnit) throws ZkInterruptedException {
        if (this.zookeeperEventThread != null && Thread.currentThread() == this.zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        Date timeout = new Date(System.currentTimeMillis() + timeUnit.toMillis(time));
        LOG.info("Waiting for keeper state " + keeperState);
        this.acquireEventLock();
        try {
            boolean stillWaiting = true;
            while (this.currentState != keeperState) {
                if (!stillWaiting) {
                    boolean bl = false;
                    return bl;
                }
                stillWaiting = this.getEventLock().getStateChangedCondition().awaitUntil(timeout);
                if (this.currentState != Watcher.Event.KeeperState.AuthFailed || !this.isZkSaslEnabled) continue;
                throw new ZkAuthFailedException("Authentication failure");
            }
            LOG.debug("State is " + this.currentState);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    private void acquireEventLock() {
        try {
            this.getEventLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
    }

    public <T> T retryUntilConnected(Callable<T> callable) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        if (this.zookeeperEventThread != null && Thread.currentThread() == this.zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        long operationStartTime = System.currentTimeMillis();
        do {
            if (this.closed) {
                throw new IllegalStateException("ZkClient already closed!");
            }
            try {
                return callable.call();
            }
            catch (KeeperException.ConnectionLossException e) {
                Thread.yield();
                this.waitForRetry();
            }
            catch (KeeperException.SessionExpiredException e) {
                Thread.yield();
                this.waitForRetry();
            }
            catch (KeeperException e) {
                throw ZkException.create(e);
            }
            catch (InterruptedException e) {
                throw new ZkInterruptedException(e);
            }
            catch (Exception e) {
                throw ExceptionUtil.convertToRuntimeException(e);
            }
        } while (this.operationRetryTimeoutInMillis <= -1L || System.currentTimeMillis() - operationStartTime < this.operationRetryTimeoutInMillis);
        throw new ZkTimeoutException("Operation cannot be retried because of retry timeout (" + this.operationRetryTimeoutInMillis + " milli seconds)");
    }

    private void waitForRetry() {
        if (this.operationRetryTimeoutInMillis < 0L) {
            this.waitUntilConnected();
            return;
        }
        this.waitUntilConnected(this.operationRetryTimeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public void setCurrentState(Watcher.Event.KeeperState currentState) {
        this.getEventLock().lock();
        try {
            this.currentState = currentState;
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public ZookeeperLock getEventLock() {
        return this.zkEventLock;
    }

    public boolean delete(String path) {
        return this.delete(path, -1);
    }

    public boolean delete(final String path, final int version) {
        try {
            this.retryUntilConnected(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ZookeeperClient.this.connection.delete(path, version);
                    return null;
                }
            });
            return true;
        }
        catch (ZkNoNodeException e) {
            return false;
        }
    }

    private byte[] serialize(Object data) {
        return this.zkSerializer.serialize(data);
    }

    private <T> T derializable(byte[] data) {
        if (data == null) {
            return null;
        }
        return (T)this.zkSerializer.deserialize(data);
    }

    public <T> T readData(String path) {
        return this.readData(path, false);
    }

    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        T data;
        block2: {
            data = null;
            try {
                data = this.readData(path, null);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return data;
    }

    public <T> T readData(String path, Stat stat) {
        return this.readData(path, stat, this.hasListeners(path));
    }

    protected <T> T readData(final String path, final Stat stat, final boolean watch) {
        byte[] data = this.retryUntilConnected(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return ZookeeperClient.this.connection.readData(path, stat, watch);
            }
        });
        return this.derializable(data);
    }

    public void writeData(String path, Object object) {
        this.writeData(path, object, -1);
    }

    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        boolean retry;
        Stat stat = new Stat();
        do {
            retry = false;
            try {
                T oldData = this.readData(path, stat);
                T newData = updater.update(oldData);
                this.writeData(path, newData, stat.getVersion());
            }
            catch (ZkBadVersionException e) {
                retry = true;
            }
        } while (retry);
    }

    public void writeData(String path, Object data, int expectedVersion) {
        this.writeDataReturnStat(path, data, expectedVersion);
    }

    public Stat writeDataReturnStat(final String path, Object data, final int expectedVersion) {
        Class<?> targetClass = this.zkSerializer.getDeserializeTargetClass();
        if (!targetClass.isInstance(data)) {
            throw new ClassCastException(data.getClass().getName() + " cannot be cast to " + targetClass.getName());
        }
        final byte[] bytes = this.serialize(data);
        return (Stat)this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Stat stat = ZookeeperClient.this.connection.writeDataReturnStat(path, bytes, expectedVersion);
                return stat;
            }
        });
    }

    public void watchForData(final String path) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZookeeperClient.this.connection.exists(path, true);
                return null;
            }
        });
    }

    public List<String> watchForChilds(final String path) {
        if (this.zookeeperEventThread != null && Thread.currentThread() == this.zookeeperEventThread) {
            throw new IllegalArgumentException("Must not be done in the zookeeper event thread.");
        }
        return this.retryUntilConnected(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ZookeeperClient.this.exists(path, true);
                try {
                    return ZookeeperClient.this.getChildren(path, true);
                }
                catch (ZkNoNodeException zkNoNodeException) {
                    return null;
                }
            }
        });
    }

    public void addAuthInfo(final String scheme, final byte[] auth) {
        this.retryUntilConnected(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ZookeeperClient.this.connection.addAuthInfo(scheme, auth);
                return null;
            }
        });
    }

    protected void connect(long maxMsToWaitUntilConnected, Watcher watcher) throws ZkInterruptedException, ZkTimeoutException, IllegalStateException {
        this.connect(maxMsToWaitUntilConnected, DEFAULT_TIMEUNIT, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(long maxMsToWaitUntilConnected, TimeUnit timeUnit, Watcher watcher) throws ZkInterruptedException, ZkTimeoutException, IllegalStateException {
        boolean started = false;
        this.acquireEventLock();
        try {
            this.setShutdownTrigger(false);
            this.eventThread = new ZookeeperEventThread(this.connection.getServers());
            this.eventThread.start();
            this.connection.connect(watcher);
            LOG.info("Awaiting connection to Zookeeper server");
            boolean waitSuccessful = this.waitUntilConnected(maxMsToWaitUntilConnected, timeUnit == null ? DEFAULT_TIMEUNIT : timeUnit);
            if (!waitSuccessful) {
                throw new ZkTimeoutException("Unable to connect to zookeeper server '" + this.connection.getServers() + "' with timeout of " + maxMsToWaitUntilConnected + (timeUnit == null ? DEFAULT_TIMEUNIT : timeUnit).name().toLowerCase());
            }
            started = true;
        }
        finally {
            this.getEventLock().unlock();
            if (!started) {
                this.close();
            }
        }
    }

    public long getCreationTime(String path) {
        this.acquireEventLock();
        try {
            long l = this.connection.getCreateTime(path);
            return l;
        }
        catch (KeeperException e) {
            throw ZkException.create(e);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public void close() throws ZkInterruptedException {
        if (this.closed) {
            return;
        }
        LOG.debug("Closing ZkClient...");
        this.getEventLock().lock();
        try {
            this.setShutdownTrigger(true);
            this.eventThread.interrupt();
            this.eventThread.join(2000L);
            this.connection.close();
            this.closed = true;
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
        LOG.debug("Closing ZkClient...done");
    }

    private void reconnect() {
        this.getEventLock().lock();
        try {
            this.connection.close();
            this.connection.connect(this);
        }
        catch (InterruptedException e) {
            throw new ZkInterruptedException(e);
        }
        finally {
            this.getEventLock().unlock();
        }
    }

    public void setShutdownTrigger(boolean triggerState) {
        this.shutdownTriggered = triggerState;
    }

    public boolean getShutdownTrigger() {
        return this.shutdownTriggered;
    }

    public int numberOfListeners() {
        int listeners = 0;
        for (Set<IZookeeperChildListener> set : this.childListener.values()) {
            listeners += set.size();
        }
        for (Set<Object> set : this.dataListener.values()) {
            listeners += set.size();
        }
        return listeners += this.stateListener.size();
    }

    public List<OpResult> multi(final Iterable<Op> ops) throws ZkException {
        if (ops == null) {
            throw new NullPointerException("ops must not be null.");
        }
        return this.retryUntilConnected(new Callable<List<OpResult>>(){

            @Override
            public List<OpResult> call() throws Exception {
                return ZookeeperClient.this.connection.multi(ops);
            }
        });
    }
}

