/*
 * Decompiled with CFR 0.152.
 */
package zkclient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zkclient.Holder;
import zkclient.ZookeeperClient;
import zkclient.exception.ZkNoNodeException;
import zkclient.listener.IZookeeperDataListener;

public final class ContentWatcher<T>
implements IZookeeperDataListener {
    private static final Logger LOG = LoggerFactory.getLogger(ContentWatcher.class);
    private Lock contentLock = new ReentrantLock(true);
    private Condition contentAvailable = this.contentLock.newCondition();
    private Holder<T> content;
    private String fileName;
    private ZookeeperClient zkClient;

    public ContentWatcher(ZookeeperClient zkClient, String fileName) {
        this.fileName = fileName;
        this.zkClient = zkClient;
    }

    public void start() {
        this.zkClient.subscribeDataChanges(this.fileName, this);
        this.readData();
        LOG.debug("Started ContentWatcher");
    }

    private void readData() {
        try {
            this.setContent(this.zkClient.readData(this.fileName));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
    }

    public void stop() {
        this.zkClient.unsubscribeDataChanges(this.fileName, this);
    }

    public void setContent(T data) {
        LOG.debug("Received new data: " + data);
        this.contentLock.lock();
        try {
            this.content = new Holder<T>(data);
            this.contentAvailable.signalAll();
        }
        finally {
            this.contentLock.unlock();
        }
    }

    @Override
    public void handleDataChange(String dataPath, Object data) {
        this.setContent(data);
    }

    @Override
    public void handleDataDeleted(String dataPath) {
    }

    public T getContent() throws InterruptedException {
        this.contentLock.lock();
        try {
            while (this.content == null) {
                this.contentAvailable.await();
            }
            T t = this.content.get();
            return t;
        }
        finally {
            this.contentLock.unlock();
        }
    }
}

