/*
 * Decompiled with CFR 0.152.
 */
package yaml;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.FileBasedConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeModel;
import org.apache.commons.configuration2.tree.NodeTreeWalker;
import org.apache.commons.configuration2.tree.ReferenceNodeHandler;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class YamlConfiguration
extends BaseHierarchicalConfiguration
implements FileBasedConfiguration {
    private int multiConfigIndex = -1;
    private String keyName;
    private Object keyValue;

    public YamlConfiguration() {
    }

    public YamlConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
    }

    public YamlConfiguration(NodeModel<ImmutableNode> model) {
        super(model);
    }

    public YamlConfiguration(int configIndex) {
        this.multiConfigIndex = configIndex;
    }

    public YamlConfiguration(String keyName, Object keyVal) {
        this.keyName = keyName;
        this.keyValue = keyVal;
    }

    public void write(Writer out) throws ConfigurationException, IOException {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        new Yaml(options).dump(this.fromNode(), out);
    }

    public void read(Reader in) throws ConfigurationException, IOException {
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder();
        ImmutableNode root = rootBuilder.create();
        Map<String, ?> load = this.load(in);
        Map<ImmutableNode, ?> elemRefMap = this.toNodeMap(load);
        ImmutableNode top = this.addChildrenToRoot(root, elemRefMap);
        this.getSubConfigurationParentModel().mergeRoot(top, "yaml", elemRefMap, null, (NodeKeyResolver)this);
    }

    private Map<String, ?> load(Reader in) {
        Yaml yaml = new Yaml();
        Iterable objects = yaml.loadAll(in);
        if (this.multiConfigIndex >= 0) {
            ArrayList out = new ArrayList();
            objects.forEach(out::add);
            return (Map)out.get(this.multiConfigIndex);
        }
        if (this.keyName != null && this.keyValue != null) {
            Map toReturn = new HashMap();
            for (Map map : objects) {
                if (!map.containsKey(this.keyName) || !map.get(this.keyName).equals(this.keyValue)) continue;
                toReturn = map;
            }
            return toReturn;
        }
        return (Map)objects.iterator().next();
    }

    ImmutableNode addChildrenToRoot(ImmutableNode root, Map<ImmutableNode, ?> elemRefMap) {
        ImmutableNode top = root;
        for (ImmutableNode node : elemRefMap.keySet()) {
            if (elemRefMap.get(node) instanceof Map) {
                top = top.addChild(this.addChildrenToRoot(node, (Map)elemRefMap.get(node)));
                continue;
            }
            if (YamlConfiguration.isNodeCollection(elemRefMap.get(node))) {
                Collection n = (Collection)elemRefMap.get(node);
                for (Map mapValue : n) {
                    top = top.addChild(this.addChildrenToRoot(node, mapValue));
                }
                continue;
            }
            top = top.addChild(node);
        }
        return top;
    }

    private static boolean isNodeCollection(Object o) {
        return o instanceof Collection && ((Collection)o).size() > 0 && ((Collection)o).iterator().next() instanceof Map;
    }

    private Map<String, Object> fromNode() {
        YamlBuilder visitor = new YamlBuilder();
        NodeTreeWalker.INSTANCE.walkBFS((Object)this.getNodeModel().getRootNode(), (ConfigurationNodeVisitor)visitor, this.getNodeModel().getNodeHandler());
        return visitor.getDocument();
    }

    Map<ImmutableNode, ?> toNodeMap(Object load) {
        Map map = (Map)load;
        HashMap<ImmutableNode, Object> nodeMap = new HashMap<ImmutableNode, Object>();
        for (String key : map.keySet()) {
            ImmutableNode currentNode;
            Object value = map.get(key);
            if (value instanceof Map) {
                currentNode = new ImmutableNode.Builder().name(key).value(value).create();
                nodeMap.put(currentNode, this.toNodeMap(value));
                continue;
            }
            if (YamlConfiguration.isNodeCollection(value)) {
                currentNode = new ImmutableNode.Builder().name(key).value(value).create();
                Collection valueMaps = (Collection)value;
                nodeMap.put(currentNode, valueMaps.stream().map(vm -> this.toNodeMap(vm)).collect(Collectors.toList()));
                continue;
            }
            Object outVal = value != null ? value : new TreeMap();
            ImmutableNode currentNode2 = new ImmutableNode.Builder().name(key).value(outVal).create();
            nodeMap.put(currentNode2, outVal);
        }
        return nodeMap;
    }

    private final class YamlBuilder
    extends BaseHierarchicalConfiguration.BuilderVisitor {
        final Map<String, Object> document = new TreeMap<String, Object>();
        final List<Shadow> documentShadow = new ArrayList<Shadow>();

        YamlBuilder() {
            this.documentShadow.add(new ShadowMapNode("yaml", "yaml", null));
        }

        protected void insert(ImmutableNode node, ImmutableNode parent, ImmutableNode siblingBefore, ImmutableNode siblingAfter, ReferenceNodeHandler handler) {
            String nodeName = node.getNodeName();
            String nodeNameEscaped = node.getNodeName().replaceAll("\\.", "\\^");
            String longNodeName = this.toLongName(parent, handler, nodeNameEscaped);
            Object value = node.getValue();
            Optional<Shadow> by = this.by(longNodeName);
            Shadow shadow = by.orElseGet(() -> this.makeShadow(parent, handler, nodeName, longNodeName, value));
            shadow.syncDocument(value);
        }

        protected void update(ImmutableNode node, Object value, ReferenceNodeHandler handler) {
            ImmutableNode parent = (ImmutableNode)handler.getParent((Object)node);
            String nodeName = node.getNodeName();
            String nodeNameEscaped = node.getNodeName().replaceAll("\\.", "\\^");
            String longNodeName = this.toLongName(parent, handler, nodeNameEscaped);
            Optional<Shadow> by = this.by(longNodeName);
            Shadow shadow = by.orElseGet(() -> this.makeShadow(parent, handler, nodeName, longNodeName, value));
            shadow.syncDocument(value);
        }

        Shadow makeShadow(ImmutableNode parent, ReferenceNodeHandler handler, String nodeName, String longNodeName, Object value) {
            Shadow newShadow;
            Shadow shadowParent = this.by(longNodeName.substring(0, longNodeName.lastIndexOf("."))).orElse(null);
            if (YamlConfiguration.isNodeCollection(value)) {
                int count = handler.getChildrenCount((Object)parent, nodeName);
                newShadow = this.shadowCollection(longNodeName, nodeName, count, shadowParent);
            } else {
                newShadow = value instanceof Map ? this.shadowMap(longNodeName, nodeName, shadowParent) : this.shadowLeaf(longNodeName, nodeName, shadowParent);
            }
            this.documentShadow.add(newShadow);
            return newShadow;
        }

        String toLongName(ImmutableNode node, ReferenceNodeHandler handler, String init) {
            if (node != null) {
                String nodePath = node.getNodeName().replaceAll("\\.", "\\^") + "." + init;
                return this.toLongName((ImmutableNode)handler.getParent((Object)node), handler, nodePath);
            }
            return init;
        }

        Map<String, Object> getDocument() {
            return this.document;
        }

        Optional<Shadow> by(String longName) {
            return this.documentShadow.stream().filter(s -> s.longName.equals(longName)).findFirst();
        }

        Shadow shadowMap(String longName, String name, Shadow parent) {
            return new ShadowMapNode(longName, name, parent);
        }

        Shadow shadowLeaf(String longName, String name, Shadow parent) {
            return new ShadowLeafNode(longName, name, parent);
        }

        Shadow shadowCollection(String longName, String name, int size, Shadow parent) {
            return new ShadowCollectionNode(longName, name, size, parent);
        }

        final class ShadowLeafNode
        extends Shadow<Object> {
            ShadowLeafNode(String longName, String name, Shadow parent) {
                super(longName, name, parent, null);
            }

            @Override
            void syncDocument(Object value) {
                if (this.parent instanceof ShadowCollectionNode) {
                    ShadowCollectionNode parent = (ShadowCollectionNode)this.parent;
                    if (((List)parent.reference).size() <= this.pointer) {
                        ((List)parent.reference).add(this.pointer, new TreeMap());
                    }
                    ((Map)((List)parent.reference).get(this.pointer)).put(this.name, value);
                    ++this.pointer;
                } else {
                    ((Map)((ShadowMapNode)this.parent).reference).put(this.name, value);
                }
            }

            @Override
            public String toString() {
                return "Leaf" + super.toString();
            }
        }

        final class ShadowMapNode
        extends Shadow<Map<String, Object>> {
            ShadowMapNode(String longName, String name, Shadow parent) {
                super(longName, name, parent, parent == null ? YamlBuilder.this.document : new TreeMap());
                if (parent instanceof ShadowMapNode) {
                    ((Map)((ShadowMapNode)parent).reference).put(name, this.reference);
                } else if (parent instanceof ShadowCollectionNode) {
                    ((Map)((List)((ShadowCollectionNode)parent).reference).get(this.pointer)).put(name, this.reference);
                    ++this.pointer;
                }
            }

            @Override
            void syncDocument(Object value) {
            }

            @Override
            public String toString() {
                return "Map" + super.toString();
            }
        }

        final class ShadowCollectionNode
        extends Shadow<List<Map<String, Object>>> {
            ShadowCollectionNode(String longName, String name, int size, Shadow parent) {
                super(longName, name, parent, new ArrayList());
                IntStream.range(0, size).forEach(i -> ((List)this.reference).add(new TreeMap()));
                if (parent instanceof ShadowMapNode) {
                    ((Map)((ShadowMapNode)parent).reference).put(name, this.reference);
                } else if (parent instanceof ShadowCollectionNode) {
                    ((Map)((List)((ShadowCollectionNode)parent).reference).get(this.pointer)).put(name, this.reference);
                    ++this.pointer;
                }
            }

            @Override
            void syncDocument(Object value) {
            }

            @Override
            public String toString() {
                return "Collection" + super.toString();
            }
        }

        abstract class Shadow<T> {
            final String name;
            final String longName;
            final Shadow parent;
            final T reference;
            int pointer = 0;

            Shadow(String longName, String name, Shadow parent, T reference) {
                this.name = name;
                this.longName = longName;
                this.parent = parent;
                this.reference = reference;
            }

            abstract void syncDocument(Object var1);

            public String toString() {
                return "Shadow@" + this.hashCode() + "{longName='" + this.longName + '\'' + '}';
            }
        }
    }
}

