/*
 * Decompiled with CFR 0.152.
 */
package yaml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.yaml.snakeyaml.Yaml;
import yaml.YamlConfiguration;

public final class YamlConfig {
    public static List<String> environments(File projectFile) throws ConfigurationException, FileNotFoundException {
        ArrayList<String> environments = new ArrayList<String>();
        environments.add("default");
        Iterable objects = new Yaml().loadAll((Reader)new FileReader(projectFile));
        for (Map next : objects) {
            if (!next.containsKey("environment")) continue;
            environments.add((String)next.get("environment"));
        }
        return environments;
    }

    public static YamlConfiguration load(String relativePath) throws ConfigurationException {
        return (YamlConfiguration)new FileBasedConfigurationBuilder(YamlConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().hierarchical().setFileName(relativePath)}).getConfiguration();
    }

    public static YamlConfiguration load(File yamlFile) throws ConfigurationException {
        return (YamlConfiguration)new FileBasedConfigurationBuilder(YamlConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().hierarchical().setFile(yamlFile)}).getConfiguration();
    }

    public static YamlConfiguration load(URL url) throws ConfigurationException {
        return (YamlConfiguration)new FileBasedConfigurationBuilder(YamlConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)new Parameters().hierarchical().setURL(url)}).getConfiguration();
    }

    public static YamlConfiguration load(String relativePath, String env) throws ConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration("environment", env);
        try (FileReader reader = new FileReader(new File(relativePath));){
            configuration.read(reader);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return configuration;
    }

    public static YamlConfiguration load(File file, String env) throws ConfigurationException {
        YamlConfiguration configuration = new YamlConfiguration("environment", env);
        try (FileReader reader = new FileReader(file);){
            configuration.read(reader);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        return configuration;
    }

    public static void write(ImmutableHierarchicalConfiguration c, File file) {
        try (FileWriter writer = new FileWriter(file);){
            ((YamlConfiguration)c).write(writer);
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

