/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.wechat.core.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMapper {
    private static Logger logger = LoggerFactory.getLogger(JsonMapper.class);
    private static JsonMapper defaultJsonMapper = null;
    private static JsonMapper nonEmptyJsonMapper = null;
    private static JsonMapper nonDefaultJsonMapper = null;
    private static JsonMapper defaultUnwrapRootJsonMapper = null;
    private ObjectMapper mapper = new ObjectMapper();

    public JsonMapper() {
        this(null, false);
    }

    public JsonMapper(boolean unwrapRoot) {
        this(null, unwrapRoot);
    }

    public JsonMapper(JsonInclude.Include include, boolean unwrapRoot) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        if (unwrapRoot) {
            this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        }
    }

    public static synchronized JsonMapper nonEmptyMapper() {
        if (nonEmptyJsonMapper == null) {
            nonEmptyJsonMapper = new JsonMapper(JsonInclude.Include.NON_EMPTY, false);
        }
        return nonEmptyJsonMapper;
    }

    public static synchronized JsonMapper nonDefaultMapper() {
        if (nonDefaultJsonMapper == null) {
            nonDefaultJsonMapper = new JsonMapper(JsonInclude.Include.NON_DEFAULT, false);
        }
        return nonDefaultJsonMapper;
    }

    public static synchronized JsonMapper defaultUnwrapRootMapper() {
        if (defaultUnwrapRootJsonMapper == null) {
            defaultUnwrapRootJsonMapper = new JsonMapper(true);
        }
        return defaultUnwrapRootJsonMapper;
    }

    public static synchronized JsonMapper defaultMapper() {
        if (defaultJsonMapper == null) {
            defaultJsonMapper = new JsonMapper();
        }
        return defaultJsonMapper;
    }

    public String toJson(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.warn("toJson\u51fa\u9519:" + object, (Throwable)e);
            return null;
        }
    }

    public <T> T fromJson(String json, Class<T> clazz) {
        if (json == null || json.trim().length() == 0) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            logger.warn("fromJson\u51fa\u9519:" + json, (Throwable)e);
            return null;
        }
    }

    public HashMap<String, Object> json2Map(String json) {
        return this.fromJson(json, HashMap.class);
    }

    public <T> T convert(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        return (T)this.mapper.convertValue(object, clazz);
    }

    public <T> List<T> fromJsons(String jsons, Class<T> clazz) throws IOException {
        if (jsons == null || jsons.trim().length() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        JsonNode jsonNode = this.mapper.readTree(jsons);
        if (jsonNode.isArray()) {
            for (JsonNode child : jsonNode) {
                list.add(this.mapper.treeToValue((TreeNode)child, clazz));
            }
        } else {
            list.add(this.fromJson(jsons, clazz));
        }
        return list;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

