/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.wechat.api.token;

import cn.dolphin.core.cache.ehcache.CacheUtils;
import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.SystemClock;
import cn.dolphin.https.client.Http;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.wechat.api.commom.WxBaseAPI;
import cn.dolphin.wechat.core.bean.AccessToken;
import cn.dolphin.wechat.core.enums.WechatEnum;
import cn.dolphin.wechat.core.util.JsonMapper;
import cn.dolphin.wechat.core.util.Wechatutils;
import java.util.HashMap;

public class TokenAPI
extends WxBaseAPI {
    public static AccessToken getToken(String appid, String secret) {
        return TokenAPI.getToken(appid, secret, false);
    }

    public static AccessToken getToken(String appid, String secret, boolean falg) {
        try {
            long currentTime;
            AccessToken token = new AccessToken();
            if (falg && EmptyUtil.isNotEmpty(CacheUtils.get("accessToken")).booleanValue() && EmptyUtil.isNotEmpty(CacheUtils.get("getTime")).booleanValue() && (currentTime = System.currentTimeMillis()) - CastUtil.castLong(CacheUtils.get("getTime")) < 0x6DDD00L) {
                token.setAccessToken((String)CacheUtils.get("accessToken"));
                token.setExpire(7200);
                return token;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "client_credential");
            params.put("appid", appid);
            params.put("secret", secret);
            HttpResult httpResult = Http.getInstance().get("https://api.weixin.qq.com/cgi-bin/token", params);
            if (httpResult.getCode() == 200) {
                Wechatutils.check(httpResult.getContent());
                token = JsonMapper.defaultMapper().fromJson(httpResult.getContent(), AccessToken.class);
                if (falg) {
                    CacheUtils.put("getTime", SystemClock.now());
                    CacheUtils.put("accessToken", token.getAccessToken());
                }
                return token;
            }
            throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

