/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.wechat.api.mp;

import cn.dolphin.core.exception.ApiException;
import cn.dolphin.core.map.StrHashMap;
import cn.dolphin.https.client.Http;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.wechat.api.commom.WxBaseAPI;
import cn.dolphin.wechat.core.enums.WechatEnum;
import cn.dolphin.wechat.core.util.JsonMapper;
import cn.dolphin.wechat.core.util.Wechatutils;
import cn.dolphin.wechat.mp.enums.AuthType;
import cn.dolphin.wechat.mp.enums.LangType;
import cn.dolphin.wechat.mp.model.oauth2.AuthAccessToken;
import cn.dolphin.wechat.mp.model.oauth2.ValidAccessToken;
import cn.dolphin.wechat.mp.model.user.UserInfo;

public class Oauth2Api
extends WxBaseAPI {
    public static String generateRedirectURI(String appid, String redirectURI, AuthType scope, String state) {
        StringBuffer url = new StringBuffer();
        url.append("https://open.weixin.qq.com/connect/oauth2/authorize");
        url.append("?appid=").append(Wechatutils.urlEncode(appid));
        url.append("&redirect_uri=").append(Wechatutils.urlEncode(redirectURI));
        url.append("&response_type=code");
        url.append("&scope=").append(Wechatutils.urlEncode(scope.scope()));
        url.append("&state=").append(Wechatutils.urlEncode(state));
        url.append("#wechat_redirect");
        return url.toString();
    }

    public static AuthAccessToken getAccessToken(String appid, String secret, String code) {
        try {
            StrHashMap params = new StrHashMap();
            params.put("appid", Wechatutils.urlEncode(appid));
            params.put("secret", Wechatutils.urlEncode(secret));
            params.put("code", Wechatutils.urlEncode(code));
            params.put("grant_type", "authorization_code");
            HttpResult httpResult = Http.getInstance().get("https://api.weixin.qq.com/sns/oauth2/access_token", params);
            if (httpResult.getCode() == 200) {
                Wechatutils.check(httpResult.getContent());
                return JsonMapper.defaultMapper().fromJson(httpResult.getContent(), AuthAccessToken.class);
            }
            throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public static AuthAccessToken refreshAccessToken(String refreshToken, String appid) {
        try {
            StrHashMap params = new StrHashMap();
            params.put("refresh_token", Wechatutils.urlEncode(refreshToken));
            params.put("appid", Wechatutils.urlEncode(appid));
            params.put("grant_type", "refresh_token");
            HttpResult httpResult = Http.getInstance().get("https://api.weixin.qq.com/sns/oauth2/refresh_token", params);
            if (httpResult.getCode() == 200) {
                Wechatutils.check(httpResult.getContent());
                return JsonMapper.defaultMapper().fromJson(httpResult.getContent(), AuthAccessToken.class);
            }
            throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public static UserInfo getUserinfo(String accessToken, String openid, LangType langType) {
        try {
            StrHashMap params = new StrHashMap();
            params.put("access_token", Wechatutils.urlEncode(accessToken));
            params.put("openid", Wechatutils.urlEncode(openid));
            params.put("lang", Wechatutils.urlEncode(langType.code()));
            HttpResult httpResult = Http.getInstance().get("https://api.weixin.qq.com/sns/userinfo", params);
            if (httpResult.getCode() == 200) {
                Wechatutils.check(httpResult.getContent());
                return JsonMapper.defaultMapper().fromJson(httpResult.getContent(), UserInfo.class);
            }
            throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }

    public static ValidAccessToken validAccessToken(String accessToken, String openid) {
        try {
            StrHashMap params = new StrHashMap();
            params.put("access_token", Wechatutils.urlEncode(accessToken));
            params.put("openid", Wechatutils.urlEncode(openid));
            HttpResult httpResult = Http.getInstance().get("https://api.weixin.qq.com/sns/auth", params);
            if (httpResult.getCode() == 200) {
                Wechatutils.check(httpResult.getContent());
                return JsonMapper.defaultMapper().fromJson(httpResult.getContent(), ValidAccessToken.class);
            }
            throw new ApiException(WechatEnum.ERROR.code(), WechatEnum.ERROR.msg());
        }
        catch (Exception e) {
            throw new ApiException(e.getMessage(), e);
        }
    }
}

