/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.wechat.api.commom;

import cn.dolphin.core.util.ListUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.https.json.HttpJson;
import cn.dolphin.wechat.mp.model.message.WxMpTemplateData;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class WxBaseAPI {
    protected static final String TOKEN = "https://api.weixin.qq.com/cgi-bin/token";

    protected static Map<String, String> buildTemplateParams(String openId, String templateId, String url, List<WxMpTemplateData> dataList) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)4);
        params.put("touser", openId);
        params.put("template_id", templateId);
        if (StrUtil.isNotBlank((CharSequence)url)) {
            params.put("url", url);
        }
        if (ListUtil.isNotEmpty(dataList)) {
            HashMap data = Maps.newHashMapWithExpectedSize((int)dataList.size());
            for (WxMpTemplateData field : dataList) {
                HashMap dataItem = Maps.newHashMapWithExpectedSize((int)2);
                dataItem.put("value", field.getValue());
                dataItem.put("color", field.getColor());
                data.put(field.getName(), dataItem);
            }
            params.put("data", data);
        }
        return HttpJson.conversion((Object)params, Map.class);
    }
}

