/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread.job;

import cn.dolphin.core.util.SystemUtil;
import cn.dolphin.thread.job.AbstractJob;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadStackJob
extends AbstractJob {
    private static Logger _logger = LoggerFactory.getLogger(ThreadStackJob.class);
    private String _lineSeparator = SystemUtil.getEndLine();
    private static final int BUFFER_SIZE = 4096;

    public ThreadStackJob(int interval) {
        this._interval = interval;
    }

    @Override
    protected void execute() {
        Map<Thread, StackTraceElement[]> stackMap = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackMap.entrySet()) {
            StackTraceElement[] stackList;
            Thread thread = entry.getKey();
            StringBuilder buffer = new StringBuilder(4096).append("name:").append(thread.getName()).append(", id:").append(thread.getId()).append(", status:").append(thread.getState().toString()).append(", priority:").append(thread.getPriority()).append(this._lineSeparator);
            for (StackTraceElement ste : stackList = entry.getValue()) {
                buffer.append(ste.toString()).append(this._lineSeparator);
            }
            _logger.info(buffer.toString());
        }
        super.sleep();
    }
}

