/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread.job;

import cn.dolphin.thread.job.AbstractJob;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolStateJob
extends AbstractJob {
    private static Logger _logger = LoggerFactory.getLogger(ThreadPoolStateJob.class);
    private Map<String, ExecutorService> _multiThreadPool;

    public ThreadPoolStateJob(Map<String, ExecutorService> multiThreadPool, int interval) {
        this._multiThreadPool = multiThreadPool;
        this._interval = interval;
    }

    @Override
    protected void execute() {
        Set<Map.Entry<String, ExecutorService>> poolSet = this._multiThreadPool.entrySet();
        for (Map.Entry<String, ExecutorService> entry : poolSet) {
            ThreadPoolExecutor pool = (ThreadPoolExecutor)entry.getValue();
            _logger.info("ThreadPool:{}, ActiveThread:{}, TotalTask:{}, CompletedTask:{}, Queue:{}", new Object[]{entry.getKey(), pool.getActiveCount(), pool.getTaskCount(), pool.getCompletedTaskCount(), pool.getQueue().size()});
        }
        super.sleep();
    }
}

