/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread.job;

import cn.dolphin.thread.ILifeCycle;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractJob
implements Runnable,
ILifeCycle {
    protected String _lineSeparator = System.getProperty("line.separator");
    protected volatile AtomicBoolean _run = new AtomicBoolean(true);
    protected int _interval = 60;

    @Override
    public void init() {
        this._run.set(true);
    }

    @Override
    public void run() {
        while (this._run.get()) {
            this.execute();
        }
    }

    protected abstract void execute();

    protected void sleep() {
        try {
            Thread.sleep(this._interval * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String currentTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = Calendar.getInstance().getTime();
        return format.format(date);
    }

    @Override
    public void destroy() {
        this._run.set(false);
    }
}

