/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread.core;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultThreadFactory
implements ThreadFactory {
    private AtomicLong _count = new AtomicLong(1L);
    private static final String DEFAULT_THREAD_NAME_PRIFIX = "dolphin-thread";
    private ThreadGroup _group;
    private String _threadNamePrefix = "dolphin-thread";

    public DefaultThreadFactory() {
        this(DEFAULT_THREAD_NAME_PRIFIX);
    }

    public DefaultThreadFactory(String threadNamePrefix) {
        this._threadNamePrefix = threadNamePrefix;
        ThreadGroup root = this.getRootThreadGroup();
        this._group = new ThreadGroup(root, this._threadNamePrefix);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread = new Thread(this._group, r);
        thread.setName(this._threadNamePrefix + "-" + this._count.getAndIncrement());
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (5 != thread.getPriority()) {
            thread.setPriority(5);
        }
        return thread;
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (null != threadGroup.getParent()) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }
}

