/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread;

import cn.dolphin.thread.ThreadStateInfo;
import java.util.HashMap;
import java.util.Map;

public class ThreadUtil {
    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (null != threadGroup.getParent()) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Map<String, ThreadStateInfo> statAllGroupThreadState() {
        ThreadGroup root = ThreadUtil.getRootThreadGroup();
        int groupCapacity = root.activeGroupCount() * 2;
        ThreadGroup[] groupList = new ThreadGroup[groupCapacity];
        int groupNum = root.enumerate(groupList, true);
        HashMap<String, ThreadStateInfo> stateInfoList = new HashMap<String, ThreadStateInfo>();
        stateInfoList.put(root.getName(), ThreadUtil.statSingleGroupThreadState(root));
        for (int i = 0; i < groupNum; ++i) {
            ThreadGroup threadGroup = groupList[i];
            ThreadStateInfo stateInfo = ThreadUtil.statSingleGroupThreadState(threadGroup);
            stateInfoList.put(threadGroup.getName(), stateInfo);
        }
        return stateInfoList;
    }

    public static ThreadStateInfo statSingleGroupThreadState(ThreadGroup threadGroup) {
        if (null == threadGroup) {
            throw new IllegalArgumentException("threadGroup is null");
        }
        int threadCapacity = threadGroup.activeCount() * 2;
        Thread[] threadList = new Thread[threadCapacity];
        int threadNum = threadGroup.enumerate(threadList);
        ThreadStateInfo stateInfo = new ThreadStateInfo();
        block8: for (int j = 0; j < threadNum; ++j) {
            Thread thread = threadList[j];
            switch (thread.getState()) {
                case NEW: {
                    ++stateInfo.newCount;
                    continue block8;
                }
                case RUNNABLE: {
                    ++stateInfo.runnableCount;
                    continue block8;
                }
                case BLOCKED: {
                    ++stateInfo.blockedCount;
                    continue block8;
                }
                case WAITING: {
                    ++stateInfo.waitingCount;
                    continue block8;
                }
                case TIMED_WAITING: {
                    ++stateInfo.timedWaitingCount;
                    continue block8;
                }
                case TERMINATED: {
                    ++stateInfo.terminatedCount;
                    continue block8;
                }
            }
        }
        return stateInfo;
    }
}

