/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread;

import cn.dolphin.thread.FailHandler;
import cn.dolphin.thread.ILifeCycle;
import cn.dolphin.thread.ThreadPool;
import cn.dolphin.thread.ThreadPoolConfig;
import cn.dolphin.thread.ThreadPoolInfo;
import cn.dolphin.thread.core.DefaultThreadFactory;
import cn.dolphin.thread.job.ThreadPoolStateJob;
import cn.dolphin.thread.job.ThreadStackJob;
import cn.dolphin.thread.job.ThreadStateJob;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jsoup.helper.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolImpl
implements ILifeCycle,
ThreadPool {
    private static final String DEFAULT_THREAD_POOL = "default";
    private static Logger _logger = LoggerFactory.getLogger(ThreadPoolImpl.class);
    protected ThreadPoolConfig _threadPoolConfig = new ThreadPoolConfig();
    protected int _status = 0;
    Map<String, ExecutorService> _multiThreadPool = new HashMap<String, ExecutorService>();
    ThreadPoolStateJob _threadPoolStateJob;
    ThreadStateJob _threadStateJob;
    ThreadStackJob _threadStackJob;

    @Override
    public void init() {
        if (0 != this._status) {
            _logger.warn("initialization thread pool failed, because the status was wrong, current status was {} (0:UNINITIALIZED, 1:INITIALITION_SUCCESSFUL, 2:INITIALITION_FAILED, 3:DESTROYED)", (Object)this._status);
            return;
        }
        try {
            this.initThreadPool();
            this.startThreadPoolStateJob();
            this.startThreadStateJob();
            this.startThreadStackJob();
            this._status = 1;
        }
        catch (RuntimeException e) {
            this._status = 2;
            throw e;
        }
    }

    private void initThreadPool() {
        this._threadPoolConfig.init();
        if (!this._threadPoolConfig.containsPool(DEFAULT_THREAD_POOL)) {
            throw new IllegalStateException(String.format("the default thread pool not exists, please check the config file '%s'", this._threadPoolConfig._configFile));
        }
        Collection<ThreadPoolInfo> threadPoolInfoList = this._threadPoolConfig.getThreadPoolConfig();
        for (ThreadPoolInfo threadPoolInfo : threadPoolInfoList) {
            ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(threadPoolInfo.getQueueSize());
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(threadPoolInfo.getCoreSize(), threadPoolInfo.getMaxSize(), threadPoolInfo.getThreadKeepAliveTime(), TimeUnit.SECONDS, workQueue, new DefaultThreadFactory(threadPoolInfo.getName()));
            this._multiThreadPool.put(threadPoolInfo.getName(), threadPool);
            _logger.info("initialization thread pool '{}' success", (Object)threadPoolInfo.getName());
        }
    }

    private void startThreadPoolStateJob() {
        if (!this._threadPoolConfig.getThreadPoolStateSwitch()) {
            return;
        }
        this._threadPoolStateJob = new ThreadPoolStateJob(this._multiThreadPool, this._threadPoolConfig.getThreadPoolStateInterval());
        this._threadPoolStateJob.init();
        Thread jobThread = new Thread(this._threadPoolStateJob);
        jobThread.setName("threadpool-threadpoolstate");
        jobThread.start();
        _logger.info("start job 'threadpool-threadpoolstate' success");
    }

    private void startThreadStateJob() {
        if (!this._threadPoolConfig.getThreadStateSwitch()) {
            return;
        }
        this._threadStateJob = new ThreadStateJob(this._threadPoolConfig.getThreadStateInterval());
        this._threadStateJob.init();
        Thread jobThread = new Thread(this._threadStateJob);
        jobThread.setName("threadpool-threadstate");
        jobThread.start();
        _logger.info("start job 'threadpool-threadstate' success");
    }

    private void startThreadStackJob() {
        if (!this._threadPoolConfig.getThreadStackSwitch()) {
            return;
        }
        this._threadStackJob = new ThreadStackJob(this._threadPoolConfig.getThreadStackInterval());
        this._threadStackJob.init();
        Thread jobThread = new Thread(this._threadStackJob);
        jobThread.setName("threadpool-threadstack");
        jobThread.start();
        _logger.info("start job 'threadpool-threadstack' success");
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.submit(task, DEFAULT_THREAD_POOL);
    }

    @Override
    public Future<?> submit(Runnable task, String threadpoolName) {
        if (null == task) {
            throw new IllegalArgumentException("task is null");
        }
        ExecutorService threadPool = this.getExistsThreadPool(threadpoolName);
        _logger.debug("submit a task to thread pool {}", (Object)threadpoolName);
        return threadPool.submit(task);
    }

    @Override
    public Future<?> submit(Runnable task, String threadpoolName, FailHandler<Runnable> failHandler) {
        try {
            return this.submit(task, threadpoolName);
        }
        catch (RejectedExecutionException e) {
            if (null != failHandler) {
                failHandler.execute(task);
            }
            return null;
        }
    }

    ExecutorService getThreadPool(String threadpoolName) {
        if (StringUtil.isBlank((String)threadpoolName)) {
            throw new IllegalArgumentException("thread pool name is empty");
        }
        ExecutorService threadPool = this._multiThreadPool.get(threadpoolName);
        return threadPool;
    }

    private ExecutorService getExistsThreadPool(String threadpoolName) {
        ExecutorService threadPool = this.getThreadPool(threadpoolName);
        if (null == threadPool) {
            throw new IllegalArgumentException(String.format("thread pool %s not exists", threadpoolName));
        }
        return threadPool;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.submit(task, DEFAULT_THREAD_POOL);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, String threadpoolName) {
        if (null == task) {
            throw new IllegalArgumentException("task is null");
        }
        ExecutorService threadPool = this.getExistsThreadPool(threadpoolName);
        _logger.debug("submit a task to thread pool {}", (Object)threadpoolName);
        return threadPool.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, String threadpoolName, FailHandler<Callable<T>> failHandler) {
        try {
            return this.submit(task, threadpoolName);
        }
        catch (RejectedExecutionException e) {
            if (null != failHandler) {
                failHandler.execute(task);
            }
            return null;
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks, long timeout, TimeUnit timeoutUnit) {
        return this.invokeAll(tasks, timeout, timeoutUnit, DEFAULT_THREAD_POOL);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> tasks, long timeout, TimeUnit timeoutUnit, String threadpoolName) {
        if (null == tasks || tasks.isEmpty()) {
            throw new IllegalArgumentException("task list is null or empty");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout less than or equals zero");
        }
        ExecutorService threadPool = this.getExistsThreadPool(threadpoolName);
        _logger.debug("invoke task list in thread pool {}", (Object)threadpoolName);
        try {
            return threadPool.invokeAll(tasks, timeout, timeoutUnit);
        }
        catch (InterruptedException e) {
            _logger.error("invoke task list occurs error", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isExists(String threadpoolName) {
        ExecutorService threadPool = this.getThreadPool(threadpoolName);
        return null != threadPool;
    }

    @Override
    public ThreadPoolInfo getThreadPoolInfo(String threadpoolName) {
        ThreadPoolInfo info = this._threadPoolConfig.getThreadPoolConfig(threadpoolName);
        return info.clone();
    }

    @Override
    public void destroy() {
        if (3 == this._status) {
            return;
        }
        for (Map.Entry<String, ExecutorService> entry : this._multiThreadPool.entrySet()) {
            _logger.info("shutdown the thread pool '{}'", (Object)entry.getKey());
            entry.getValue().shutdown();
        }
        if (null != this._threadPoolStateJob) {
            this._threadPoolStateJob.destroy();
            _logger.info("stop job 'threadpool-threadpoolstate' success");
            this._threadPoolStateJob = null;
        }
        if (null != this._threadStateJob) {
            this._threadStateJob.destroy();
            _logger.info("stop job 'threadpool-threadstate' success");
            this._threadStateJob = null;
        }
        if (null != this._threadStackJob) {
            this._threadStackJob.destroy();
            _logger.info("stop job 'threadpool-threadstack' success");
            this._threadStackJob = null;
        }
        this._threadPoolConfig.destroy();
        this._status = 3;
    }
}

