/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.thread;

import cn.dolphin.thread.ILifeCycle;
import cn.dolphin.thread.ThreadPoolInfo;
import cn.dolphin.thread.xml.DomUtil;
import cn.dolphin.thread.xml.NodeParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ThreadPoolConfig
implements ILifeCycle {
    public static final String DEFAULT_CONFIG_FILE = "/threadpool.xml";
    protected String _configFile = "/threadpool.xml";
    protected Map<String, ThreadPoolInfo> _multiThreadPoolInfo = new HashMap<String, ThreadPoolInfo>();
    protected boolean _threadPoolStateSwitch = false;
    protected int _threadPoolStateInterval = 60;
    protected boolean _threadStateSwitch = false;
    protected int _threadStateInterval = 60;
    protected boolean _threadStackSwitch = false;
    protected int _threadStackInterval = 60;

    @Override
    public void init() {
        this.initConfig();
    }

    private void initConfig() {
        Document document = DomUtil.createDocument(this._configFile);
        Element root = document.getDocumentElement();
        NodeParser rootParser = new NodeParser(root);
        List<Node> nodeList = rootParser.getChildNodes();
        for (Node node : nodeList) {
            NodeParser nodeParser = new NodeParser(node);
            if ("pool".equals(node.getNodeName())) {
                ThreadPoolInfo info = new ThreadPoolInfo();
                info.setName(nodeParser.getAttributeValue("name"));
                info.setCoreSize(Integer.parseInt(nodeParser.getChildNodeValue("corePoolSize")));
                info.setMaxSize(Integer.parseInt(nodeParser.getChildNodeValue("maxPoolSize")));
                info.setThreadKeepAliveTime(Long.parseLong(nodeParser.getChildNodeValue("keepAliveTime")));
                info.setQueueSize(Integer.parseInt(nodeParser.getChildNodeValue("workQueueSize")));
                this._multiThreadPoolInfo.put(info.getName(), info);
                continue;
            }
            if ("threadpoolstate".equals(node.getNodeName())) {
                this._threadPoolStateSwitch = this.computeSwitchValue(nodeParser);
                this._threadPoolStateInterval = this.computeIntervalValue(nodeParser);
                continue;
            }
            if ("threadstate".equals(node.getNodeName())) {
                this._threadStateSwitch = this.computeSwitchValue(nodeParser);
                this._threadStateInterval = this.computeIntervalValue(nodeParser);
                continue;
            }
            if (!"threadstack".equals(node.getNodeName())) continue;
            this._threadStackSwitch = this.computeSwitchValue(nodeParser);
            this._threadStackInterval = this.computeIntervalValue(nodeParser);
        }
    }

    private boolean computeSwitchValue(NodeParser nodeParser) {
        return "on".equalsIgnoreCase(nodeParser.getAttributeValue("switch"));
    }

    private int computeIntervalValue(NodeParser nodeParser) {
        return Integer.parseInt(nodeParser.getAttributeValue("interval"));
    }

    public boolean containsPool(String poolName) {
        if (null == poolName || null == this._multiThreadPoolInfo || this._multiThreadPoolInfo.isEmpty()) {
            return false;
        }
        return this._multiThreadPoolInfo.containsKey(poolName);
    }

    public ThreadPoolInfo getThreadPoolConfig(String threadpoolName) {
        return this._multiThreadPoolInfo.get(threadpoolName);
    }

    public Collection<ThreadPoolInfo> getThreadPoolConfig() {
        return this._multiThreadPoolInfo.values();
    }

    public boolean getThreadPoolStateSwitch() {
        return this._threadPoolStateSwitch;
    }

    public int getThreadPoolStateInterval() {
        return this._threadPoolStateInterval;
    }

    public boolean getThreadStateSwitch() {
        return this._threadStateSwitch;
    }

    public int getThreadStateInterval() {
        return this._threadStateInterval;
    }

    public boolean getThreadStackSwitch() {
        return this._threadStackSwitch;
    }

    public int getThreadStackInterval() {
        return this._threadStackInterval;
    }

    @Override
    public void destroy() {
        this._threadPoolStateSwitch = false;
        this._threadStateSwitch = false;
        this._multiThreadPoolInfo.clear();
    }
}

