/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.logger;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggerHelper {
    private static final Map<String, Logger> LOGGER_MAP = new HashMap<String, Logger>();

    private LoggerHelper() {
    }

    private static Logger getLogger(Class<?> clazz) {
        Logger logger = LOGGER_MAP.get(clazz.getName());
        if (logger == null) {
            logger = LoggerFactory.getLogger(clazz);
            LOGGER_MAP.put(clazz.getName(), logger);
        }
        return logger;
    }

    public static boolean isTraceEnabled(Class<?> clazz) {
        return LoggerHelper.getLogger(clazz).isTraceEnabled();
    }

    public static void trace(Class<?> clazz, String msg) {
        LoggerHelper.getLogger(clazz).trace(msg);
    }

    public static void trace(Class<?> clazz, String format, Object arg) {
        LoggerHelper.getLogger(clazz).trace(format, arg);
    }

    public static void trace(Class<?> clazz, String format, Object arg1, Object arg2) {
        LoggerHelper.getLogger(clazz).trace(format, arg1, arg2);
    }

    public static void trace(Class<?> clazz, String format, Object ... arguments) {
        LoggerHelper.getLogger(clazz).trace(format, arguments);
    }

    public static void trace(Class<?> clazz, String msg, Throwable t) {
        LoggerHelper.getLogger(clazz).trace(msg, t);
    }

    public static boolean isDebugEnabled(Class<?> clazz) {
        return LoggerHelper.getLogger(clazz).isDebugEnabled();
    }

    public static void debug(Class<?> clazz, String msg) {
        LoggerHelper.getLogger(clazz).debug(msg);
    }

    public static void debug(Class<?> clazz, String format, Object arg) {
        LoggerHelper.getLogger(clazz).debug(format, arg);
    }

    public static void debug(Class<?> clazz, String format, Object arg1, Object arg2) {
        LoggerHelper.getLogger(clazz).debug(format, arg1, arg2);
    }

    public static void debug(Class<?> clazz, String format, Object ... arguments) {
        LoggerHelper.getLogger(clazz).debug(format, arguments);
    }

    public static void debug(Class<?> clazz, String msg, Throwable t) {
        LoggerHelper.getLogger(clazz).debug(msg, t);
    }

    public static boolean isInfoEnabled(Class<?> clazz) {
        return LoggerHelper.getLogger(clazz).isInfoEnabled();
    }

    public static void info(Class<?> clazz, String msg) {
        LoggerHelper.getLogger(clazz).info(msg);
    }

    public static void info(Class<?> clazz, String format, Object arg) {
        LoggerHelper.getLogger(clazz).info(format, arg);
    }

    public static void info(Class<?> clazz, String format, Object arg1, Object arg2) {
        LoggerHelper.getLogger(clazz).info(format, arg1, arg2);
    }

    public static void info(Class<?> clazz, String format, Object ... arguments) {
        LoggerHelper.getLogger(clazz).info(format, arguments);
    }

    public static void info(Class<?> clazz, String msg, Throwable t) {
        LoggerHelper.getLogger(clazz).info(msg, t);
    }

    public static boolean isWarnEnabled(Class<?> clazz) {
        return LoggerHelper.getLogger(clazz).isWarnEnabled();
    }

    public static void warn(Class<?> clazz, String msg) {
        LoggerHelper.getLogger(clazz).warn(msg);
    }

    public static void warn(Class<?> clazz, String format, Object arg) {
        LoggerHelper.getLogger(clazz).warn(format, arg);
    }

    public static void warn(Class<?> clazz, String format, Object ... arguments) {
        LoggerHelper.getLogger(clazz).warn(format, arguments);
    }

    public static void warn(Class<?> clazz, String format, Object arg1, Object arg2) {
        LoggerHelper.getLogger(clazz).warn(format, arg1, arg2);
    }

    public static void warn(Class<?> clazz, String msg, Throwable t) {
        LoggerHelper.getLogger(clazz).warn(msg, t);
    }

    public static boolean isErrorEnabled(Class<?> clazz) {
        return LoggerHelper.getLogger(clazz).isErrorEnabled();
    }

    public static void error(Class<?> clazz, String msg) {
        LoggerHelper.getLogger(clazz).error(msg);
    }

    public static void error(Class<?> clazz, String format, Object arg) {
        LoggerHelper.getLogger(clazz).error(format, arg);
    }

    public static void error(Class<?> clazz, String format, Object arg1, Object arg2) {
        LoggerHelper.getLogger(clazz).error(format, arg1, arg2);
    }

    public static void error(Class<?> clazz, String format, Object ... arguments) {
        LoggerHelper.getLogger(clazz).error(format, arguments);
    }

    public static void error(Class<?> clazz, String msg, Throwable t) {
        LoggerHelper.getLogger(clazz).error(msg, t);
    }

    public static void main(String[] args) {
        LoggerHelper.debug(LoggerHelper.class.getClass(), "This is a debug.");
        LoggerHelper.info(LoggerHelper.class.getClass(), "This is a info.");
        LoggerHelper.info(LoggerHelper.class.getClass(), "This is a {}.", (Object)"info");
        LoggerHelper.info(LoggerHelper.class.getClass(), "This is {} {}.", (Object)"a", (Object)"info");
        LoggerHelper.info(LoggerHelper.class.getClass(), "This {} {} {}.", "is", "a", "info");
        LoggerHelper.info(LoggerHelper.class.getClass(), "This is a info.", new Exception("This is a info."));
    }
}

