/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.ip.ipipnet;

import cn.dolphin.ip.ipipnet.CommUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IP {
    private static final Logger LOG = Logger.getLogger(IP.class.getName());
    private static int[] ipArr;
    private static int[][] valArr;
    private static String[] countryArr;
    private static String[] regionArr;
    private static String[] cityArr;

    public static String find(String ip) {
        return IP.find(CommUtil.ipToInt(ip));
    }

    public static String find(int address) {
        String[] arr = IP.findArr(address);
        StringBuilder bud = new StringBuilder(arr[0]);
        if (arr.length > 1) {
            for (int i = 1; i < arr.length; ++i) {
                if (arr[i - 1].equals(arr[i])) continue;
                bud.append(arr[i]);
            }
        }
        return bud.toString();
    }

    public static String[] findArr(String ip) {
        return IP.findArr(CommUtil.ipToInt(ip));
    }

    public static String[] findArr(int address) {
        int[] indArr;
        int ind = Arrays.binarySearch(ipArr, address);
        if (ind < 0) {
            ind *= -1;
            ind -= 2;
        }
        if ((indArr = valArr[ind]).length == 3) {
            return new String[]{countryArr[indArr[0]], regionArr[indArr[1]], cityArr[indArr[2]]};
        }
        if (indArr.length == 2) {
            return new String[]{countryArr[indArr[0]], regionArr[indArr[1]]};
        }
        if (indArr.length == 1) {
            return new String[]{countryArr[indArr[0]]};
        }
        return new String[]{""};
    }

    private static void load(String fileName) {
        try (InputStream is = CommUtil.getDefaultClassLoader().getResourceAsStream(fileName);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String str;
            int i = 0;
            while ((str = reader.readLine()) != null) {
                IP.initData(i, str);
                ++i;
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "IP \u6570\u636e\u5e93\u52a0\u8f7d\u51fa\u9519\uff1a", e);
        }
    }

    private static void initData(int i, String s) {
        if (s == null) {
            return;
        }
        String str = IP.unGzip(s);
        switch (i) {
            case 0: {
                String[] arr = str.split(",", -1);
                ipArr = new int[arr.length];
                for (int j = 0; j < arr.length; ++j) {
                    IP.ipArr[j] = Integer.parseInt(arr[j]);
                }
                break;
            }
            case 1: {
                String[] arr = str.split(",", -1);
                valArr = new int[arr.length][];
                for (int j = 0; j < arr.length; ++j) {
                    String[] temp = arr[j].split(";");
                    IP.valArr[j] = new int[temp.length];
                    for (int k = 0; k < temp.length; ++k) {
                        IP.valArr[j][k] = Integer.parseInt(temp[k]);
                    }
                }
                break;
            }
            case 2: {
                countryArr = str.split(",", -1);
                break;
            }
            case 3: {
                regionArr = str.split(",", -1);
                break;
            }
            case 4: {
                cityArr = str.split(",", -1);
                break;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String unGzip(String input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IP() {
    }

    static {
        IP.load("dat/ipData.txt");
    }
}

