/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.https.proxy;

import cn.dolphin.https.base.ConnectPool;
import cn.dolphin.https.proxy.IdleConnectionEvictor;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;

public class CloseableHttpClientBuilder {
    private CloseableHttpClientBuilder() {
    }

    private static HttpClientConnectionManager createClientConnectionManager(ConnectPool connectPool) {
        SSLContext sslContext;
        try {
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        PoolingHttpClientConnectionManager clientConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        clientConnectionManager.setMaxTotal(connectPool.getAllMaxActive());
        clientConnectionManager.setDefaultMaxPerRoute(connectPool.getSingleMaxActive());
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).setSoReuseAddress(true).setSoTimeout(connectPool.getSocketTimeout()).setSoLinger(6).setSoKeepAlive(true).build();
        clientConnectionManager.setDefaultSocketConfig(socketConfig);
        return clientConnectionManager;
    }

    private static RequestConfig createRequestConfig(ConnectPool connectPool) {
        return RequestConfig.custom().setConnectTimeout(connectPool.getConnectTimeout()).setSocketTimeout(connectPool.getSocketTimeout()).setConnectionRequestTimeout(connectPool.getConnectionRequestTimeout()).build();
    }

    private static HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return (exception, executionCount, context) -> {
            if (executionCount >= 3) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof SSLException) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpRequest request = clientContext.getRequest();
            return !(request instanceof HttpEntityEnclosingRequest);
        };
    }

    private static ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy(final ConnectPool connectPool) {
        return new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long result = super.getKeepAliveDuration(response, context);
                if (result <= 0L) {
                    result = connectPool.getKeepAliveDuration();
                }
                return result;
            }
        };
    }

    private static CloseableHttpClient getHttpClient(ConnectPool connectPool) {
        if (connectPool == null) {
            return HttpClients.createDefault();
        }
        HttpClientConnectionManager clientConnectionManager = CloseableHttpClientBuilder.createClientConnectionManager(connectPool);
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager(clientConnectionManager).setKeepAliveStrategy(CloseableHttpClientBuilder.createConnectionKeepAliveStrategy(connectPool)).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setDefaultRequestConfig(CloseableHttpClientBuilder.createRequestConfig(connectPool)).setRetryHandler(CloseableHttpClientBuilder.createHttpRequestRetryHandler()).setConnectionManagerShared(connectPool.getConnectionManagerShared().booleanValue()).build();
        IdleConnectionEvictor idleConnectionEvictor = new IdleConnectionEvictor(clientConnectionManager, connectPool.getMaxIdleTime(), connectPool.getCleanSleepTime());
        idleConnectionEvictor.start();
        return httpClient;
    }

    public static CloseableHttpClient builder(ConnectPool connectPool) {
        return CloseableHttpClientBuilder.getHttpClient(connectPool);
    }
}

