/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.https.json;

import cn.dolphin.https.json.jackson.JsonBooleanDeserializer;
import cn.dolphin.https.json.jackson.JsonDateDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class HttpJson {
    private static ObjectMapper defaultObjectMapper = new ObjectMapper();
    private static ObjectMapper defaultSnameCaseObjectMapper = new ObjectMapper();
    private static SimpleModule simpleModule = new SimpleModule();

    private static void initUniversalConfig(ObjectMapper objectMapper) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)simpleModule);
    }

    public static String toJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            if (obj instanceof InputStream) {
                Map map = (Map)defaultObjectMapper.readValue((InputStream)obj, Map.class);
                obj = map;
            }
            return defaultObjectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object obj, JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        if (obj instanceof String) {
            return (String)obj;
        }
        ObjectMapper objectMapper = new ObjectMapper(jf, sp, dc);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (obj instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)obj, Map.class);
                obj = map;
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object obj, JsonFactory jf) {
        if (obj instanceof String) {
            return (String)obj;
        }
        ObjectMapper objectMapper = new ObjectMapper(jf);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (obj instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)obj, Map.class);
                obj = map;
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toJsonString(Object obj, String datePattern) {
        if (obj instanceof String) {
            return (String)obj;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (obj instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)obj, Map.class);
                obj = map;
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toSnameCaseJsonString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            if (obj instanceof InputStream) {
                Map map = (Map)defaultSnameCaseObjectMapper.readValue((InputStream)obj, Map.class);
                obj = map;
            }
            return defaultSnameCaseObjectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toSnameCaseJsonString(Object obj, String datePattern) {
        if (obj instanceof String) {
            return (String)obj;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (obj instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)obj, Map.class);
                obj = map;
            }
            return objectMapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, Class<T> type) {
        try {
            if (data instanceof InputStream) {
                Map map = (Map)defaultObjectMapper.readValue((InputStream)data, Map.class);
                data = defaultObjectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : defaultObjectMapper.writeValueAsString(data);
            Object newData = defaultObjectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, Class<T> type, String datePattern) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, Class<T> type, JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        ObjectMapper objectMapper = new ObjectMapper(jf, sp, dc);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, Class<T> type, JsonFactory jf) {
        ObjectMapper objectMapper = new ObjectMapper(jf);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T snameCaseConversion(Object data, Class<T> type) {
        try {
            if (data instanceof InputStream) {
                Map map = (Map)defaultSnameCaseObjectMapper.readValue((InputStream)data, Map.class);
                data = defaultSnameCaseObjectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : defaultSnameCaseObjectMapper.writeValueAsString(data);
            Object newData = defaultSnameCaseObjectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T snameCaseConversion(Object data, Class<T> type, String datePattern) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, JavaType type) {
        try {
            if (data instanceof InputStream) {
                Map map = (Map)defaultObjectMapper.readValue((InputStream)data, Map.class);
                data = defaultObjectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : defaultObjectMapper.writeValueAsString(data);
            Object newData = defaultObjectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, JavaType type, String datePattern) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, JavaType type, JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        ObjectMapper objectMapper = new ObjectMapper(jf, sp, dc);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, JavaType type, JsonFactory jf) {
        ObjectMapper objectMapper = new ObjectMapper(jf);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T snameCaseConversion(Object data, JavaType type) {
        try {
            if (data instanceof InputStream) {
                Map map = (Map)defaultSnameCaseObjectMapper.readValue((InputStream)data, Map.class);
                data = defaultSnameCaseObjectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : defaultSnameCaseObjectMapper.writeValueAsString(data);
            Object newData = defaultSnameCaseObjectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T snameCaseConversion(Object data, JavaType type, String datePattern) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static JavaType getJavaType(Class<?> parametrized, Class<?> ... parameterClasses) {
        return TypeFactory.defaultInstance().constructParametricType(parametrized, (Class[])parameterClasses);
    }

    public static JavaType getJavaType(Class<?> rawType, JavaType ... parameterTypes) {
        return TypeFactory.defaultInstance().constructParametricType(rawType, parameterTypes);
    }

    public static <T> T conversion(Object data, TypeReference<?> type) {
        try {
            if (data instanceof InputStream) {
                Map map = (Map)defaultObjectMapper.readValue((InputStream)data, Map.class);
                data = defaultObjectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : defaultObjectMapper.writeValueAsString(data);
            Object newData = defaultObjectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, TypeReference<?> type, String datePattern) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, TypeReference<?> type, JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        ObjectMapper objectMapper = new ObjectMapper(jf, sp, dc);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T conversion(Object data, TypeReference<?> type, JsonFactory jf) {
        ObjectMapper objectMapper = new ObjectMapper(jf);
        objectMapper.registerModule((Module)simpleModule);
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T snameCaseConversion(Object data, TypeReference<?> type) {
        try {
            if (data instanceof InputStream) {
                Map map = (Map)defaultSnameCaseObjectMapper.readValue((InputStream)data, Map.class);
                data = defaultSnameCaseObjectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : defaultSnameCaseObjectMapper.writeValueAsString(data);
            Object newData = defaultSnameCaseObjectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T snameCaseConversion(Object data, TypeReference<?> type, String datePattern) {
        ObjectMapper objectMapper = new ObjectMapper();
        HttpJson.initUniversalConfig(objectMapper);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(datePattern));
        try {
            if (data instanceof InputStream) {
                Map map = (Map)objectMapper.readValue((InputStream)data, Map.class);
                data = objectMapper.writeValueAsString((Object)map);
            }
            String stringValue = null;
            stringValue = data instanceof String ? (String)data : objectMapper.writeValueAsString(data);
            Object newData = objectMapper.readValue(stringValue, type);
            return (T)newData;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        simpleModule.addDeserializer(Date.class, (JsonDeserializer)new JsonDateDeserializer());
        simpleModule.addDeserializer(Boolean.class, (JsonDeserializer)new JsonBooleanDeserializer());
        HttpJson.initUniversalConfig(defaultObjectMapper);
        HttpJson.initUniversalConfig(defaultSnameCaseObjectMapper);
        defaultSnameCaseObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
    }
}

