/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.https.common;

import cn.dolphin.core.io.IOUtil;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.xml.Dom4jUtil;
import cn.dolphin.https.base.ConnectPool;
import cn.dolphin.https.json.HttpJson;
import cn.dolphin.https.model.HttpResult;
import cn.dolphin.https.proxy.CloseableHttpClientBuilder;
import cn.dolphin.https.util.Qs;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public abstract class Request<T extends Request> {
    protected static Logger logger = LoggerFactory.getLogger(Request.class);
    protected static Header jsonHeader = new BasicHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
    protected static Header xmlHeader = new BasicHeader("Content-Type", ContentType.APPLICATION_XML.toString());
    protected static Header htmlHeader = new BasicHeader("Content-Type", ContentType.TEXT_HTML.toString());
    protected static Header streamHeader = new BasicHeader("Content-Type", ContentType.APPLICATION_OCTET_STREAM.toString());
    protected static Header formHeader = new BasicHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.toString());
    protected static CloseableHttpClient httpClient;
    protected static ConnectPool connectPool;
    protected static final String ENCODING = "UTF-8";
    protected static final int CONNECT_TIMEOUT = 5000;
    protected static final int SOCKET_TIMEOUT = 10000;

    public Request(ConnectPool connectPool) {
        if (connectPool == null) {
            connectPool = new ConnectPool();
        }
        Request.connectPool = connectPool;
    }

    public Request() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableHttpClient getHttpClient() {
        if (connectPool == null) {
            return HttpClients.createDefault();
        }
        if (httpClient == null) {
            Request request = this;
            synchronized (request) {
                if (httpClient == null) {
                    httpClient = CloseableHttpClientBuilder.builder(connectPool);
                }
            }
        }
        return httpClient;
    }

    public void close() {
        try {
            if (httpClient != null) {
                httpClient.close();
                httpClient = null;
            }
        }
        catch (IOException e) {
            logger.error("http\u5de5\u5177\u5173\u95ed\u8fde\u63a5\u6c60\u5f02\u5e38", (Throwable)e);
        }
    }

    public void close2() {
        try {
            if (httpClient != null) {
                httpClient.close();
            }
        }
        catch (IOException e) {
            logger.error("http\u5de5\u5177\u5173\u95ed\u8fde\u63a5\u6c60\u5f02\u5e38", (Throwable)e);
        }
    }

    protected static void release(CloseableHttpResponse httpResponse, CloseableHttpClient httpClient) {
        try {
            if (httpResponse != null) {
                httpResponse.close();
            }
        }
        catch (IOException e) {
            logger.error("http\u5de5\u5177\u5173\u95ed\u8fde\u63a5\u6c60\u5f02\u5e38", (Throwable)e);
        }
    }

    protected static void packageHeader(Map<String, String> headers, HttpRequestBase httpMethod) {
        if (!ObjectUtils.isEmpty(headers)) {
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)httpMethod).setHeader(arg_0, arg_1));
        }
    }

    protected static void packageParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) {
        if (params != null) {
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            Set<Map.Entry<String, String>> entrySet = params.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                nvps.add(new BasicNameValuePair(CastUtil.castString(entry.getKey()), CastUtil.castString(entry.getValue())));
            }
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nvps, Charset.forName(ENCODING));
            formEntity.setContentType(formHeader);
            formEntity.setContentEncoding(ENCODING);
            httpMethod.setEntity((HttpEntity)formEntity);
        }
    }

    protected static void packageJsonParam(Map<String, String> params, HttpEntityEnclosingRequestBase httpMethod) {
        if (params != null) {
            StringEntity stringEntity = new StringEntity(HttpJson.toJsonString(params), ENCODING);
            stringEntity.setContentType(jsonHeader);
            stringEntity.setContentEncoding(ENCODING);
            httpMethod.setEntity((HttpEntity)stringEntity);
        }
    }

    protected static void packageJsonParam(String json, HttpEntityEnclosingRequestBase httpMethod) {
        if (json != null) {
            StringEntity stringEntity = new StringEntity(json, ENCODING);
            stringEntity.setContentType(jsonHeader);
            stringEntity.setContentEncoding(ENCODING);
            httpMethod.setEntity((HttpEntity)stringEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HttpResult getHttpClientResult(CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
            if (httpResponse != null && httpResponse.getStatusLine() != null) {
                String content = "";
                if (httpResponse.getEntity() != null) {
                    content = Request.entryToString(httpResponse.getEntity());
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                }
                HttpResult httpResult = new HttpResult(httpResponse.getStatusLine().getStatusCode(), content);
                return httpResult;
            }
            HttpResult content = new HttpResult(500);
            return content;
        }
        catch (Exception e) {
            HttpResult httpResult = new HttpResult(500);
            return httpResult;
        }
        finally {
            Request.release(httpResponse, httpClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HttpResult getHttpClientResultXml(CloseableHttpClient httpClient, HttpRequestBase httpMethod) throws Exception {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpMethod);
            if (httpResponse != null && httpResponse.getStatusLine() != null) {
                String content = "";
                if (httpResponse.getEntity() != null) {
                    content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)ENCODING);
                    Map result = Dom4jUtil.toMap(content, ENCODING);
                    content = HttpJson.toJsonString(result);
                    EntityUtils.consume((HttpEntity)httpResponse.getEntity());
                }
                HttpResult httpResult = new HttpResult(httpResponse.getStatusLine().getStatusCode(), content);
                return httpResult;
            }
            HttpResult content = new HttpResult(500);
            return content;
        }
        catch (Exception e) {
            HttpResult httpResult = new HttpResult(500);
            return httpResult;
        }
        finally {
            Request.release(httpResponse, httpClient);
        }
    }

    public CloseableHttpResponse headRequest(String url, Header ... headers) {
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpHead httpHead = new HttpHead(url);
        if (headers != null && headers.length != 0) {
            httpHead.setHeaders(headers);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpHead);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse headRequest(String url) {
        return this.headRequest(url, null);
    }

    public CloseableHttpResponse headRequest(String url, Object urlParams, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.contains("?") ? url + "&" + urlParam : url + "?" + urlParam;
        }
        return this.headRequest(url, headers);
    }

    public CloseableHttpResponse headRequest(String url, Object urlParams) {
        return this.headRequest(url, urlParams, (Header[])null);
    }

    public CloseableHttpResponse optionsRequest(String url, Header ... headers) {
        if (logger.isTraceEnabled()) {
            logger.trace("\u672c\u6b21\u8bf7\u6c42\u5730\u5740:" + url);
        }
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpOptions httpOptions = new HttpOptions(url);
        if (headers != null && headers.length != 0) {
            httpOptions.setHeaders(headers);
        }
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public CloseableHttpResponse optionsRequest(String url) {
        return this.optionsRequest(url, null);
    }

    public CloseableHttpResponse optionsRequest(String url, Object urlParams, Header ... headers) {
        if (urlParams != null) {
            String urlParam = Qs.stringify(urlParams);
            url = url.contains("?") ? url + "&" + urlParam : url + "?" + urlParam;
        }
        return this.optionsRequest(url, headers);
    }

    public CloseableHttpResponse optionsRequest(String url, Object urlParams) {
        return this.optionsRequest(url, urlParams, (Header[])null);
    }

    public <T> T responseDataConversion(HttpResponse response, Class<T> type) {
        if (response == null) {
            return null;
        }
        HttpEntity entity = response.getEntity();
        String entityString = null;
        try {
            entityString = Request.entryToString(entity);
        }
        catch (IOException | ParseException e1) {
            throw new RuntimeException(e1);
        }
        T result = null;
        result = HttpJson.conversion((Object)entityString, type);
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    protected static String entryToString(HttpEntity entry) throws IOException {
        String result = null;
        if (entry != null) {
            long length = entry.getContentLength();
            if (length != -1L && length < 2048L) {
                result = EntityUtils.toString((HttpEntity)entry, (String)ENCODING);
                result = JSON.toJSONString((Object)JSON.parseObject((String)result), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            } else {
                int l;
                InputStreamReader reader = new InputStreamReader(entry.getContent(), ENCODING);
                CharArrayBuffer buffer = new CharArrayBuffer(2048);
                char[] temp = new char[1024];
                while ((l = reader.read(temp)) != -1) {
                    buffer.append(temp, 0, l);
                }
                IOUtil.close(reader);
                result = buffer.toString();
            }
        }
        return result;
    }

    protected static String mapToString(String url, Map<String, String> params, String first) {
        StringBuilder sb = url != null ? new StringBuilder(url) : new StringBuilder();
        if (params != null) {
            boolean isFirst = true;
            for (String key : params.keySet()) {
                if (isFirst) {
                    if (first != null) {
                        sb.append(first);
                    }
                    isFirst = false;
                } else {
                    sb.append("&");
                }
                sb.append(key);
                sb.append("=");
                sb.append(params.get(key));
            }
        }
        return sb.toString();
    }
}

