/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.https.common;

import cn.dolphin.https.common.Request;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class Multipart
extends Request<Multipart> {
    private static volatile Multipart multipart = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Multipart getInstance() {
        if (multipart != null) return multipart;
        Class<Multipart> clazz = Multipart.class;
        synchronized (Multipart.class) {
            if (multipart != null) return multipart;
            multipart = new Multipart();
            // ** MonitorExit[var0] (shouldn't be in output)
            return multipart;
        }
    }

    public String upload(String url, File file) {
        ArrayList<File> files = new ArrayList<File>();
        files.add(file);
        return this.uploads(url, files, null);
    }

    public String upload(String url, Map<String, String> params) {
        try {
            CloseableHttpClient httpClient = this.getHttpClient();
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (params != null && params.size() > 0) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (value instanceof File) {
                        File file = (File)((Object)value);
                        builder.addPart(key, (ContentBody)new FileBody(file));
                        continue;
                    }
                    if (value == null) continue;
                    builder.addTextBody(key, value.toString(), ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8"));
                }
            }
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String uploads(String url, List<File> files, Map<String, String> params) {
        try {
            CloseableHttpClient httpClient = this.getHttpClient();
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            if (files != null && files.size() > 0) {
                for (File file : files) {
                    builder.addBinaryBody(UUID.randomUUID().toString(), file, ContentType.MULTIPART_FORM_DATA, file.getName());
                }
            }
            if (params != null && params.size() > 0) {
                for (Map.Entry entry : params.entrySet()) {
                    builder.addTextBody((String)entry.getKey(), ((String)entry.getValue()).toString(), ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8"));
                }
            }
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setContentType(ContentType.MULTIPART_FORM_DATA);
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity(), (String)"UTF-8");
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean download(String remoteFileUrl, String localFilePath) throws Exception {
        boolean bl;
        CloseableHttpResponse response = null;
        InputStream in = null;
        FileOutputStream fout = null;
        try {
            int l;
            CloseableHttpClient httpClient = this.getHttpClient();
            HttpGet httpget = new HttpGet(remoteFileUrl);
            response = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                boolean bl2 = false;
                return bl2;
            }
            in = entity.getContent();
            File file = new File(localFilePath);
            fout = new FileOutputStream(file);
            byte[] tmp = new byte[1024];
            while ((l = in.read(tmp)) != -1) {
                fout.write(tmp, 0, l);
            }
            fout.flush();
            EntityUtils.consume((HttpEntity)entity);
            bl = true;
        }
        catch (Exception e) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception exception) {}
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }
}

