/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.email.queue;

import cn.dolphin.email.entity.Email;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class MailQueue {
    public static final int QUEUE_MAX_SIZE = 1000;
    public static BlockingQueue<Email> blockingQueue = new LinkedBlockingQueue<Email>(1000);

    private MailQueue() {
    }

    public static MailQueue getMailQueue() {
        return SingletonHolder.queue;
    }

    public void produce(Email mail) throws InterruptedException {
        blockingQueue.put(mail);
    }

    public Email consume() throws InterruptedException {
        return blockingQueue.take();
    }

    public int size() {
        return blockingQueue.size();
    }

    private static class SingletonHolder {
        private static MailQueue queue = new MailQueue();

        private SingletonHolder() {
        }
    }
}

