/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.email.mail;

import cn.dolphin.core.date.TimeUtil;
import cn.dolphin.core.freemarker.FreemarkerUtil;
import cn.dolphin.core.util.CastUtil;
import cn.dolphin.core.util.EmptyUtil;
import cn.dolphin.core.util.ListUtil;
import cn.dolphin.core.util.StrUtil;
import cn.dolphin.email.entity.AttachmentFile;
import cn.dolphin.email.entity.EmailAuthenticator;
import cn.dolphin.email.entity.EmailResult;
import cn.dolphin.email.util.MailUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailMessage {
    private static Logger logger = LoggerFactory.getLogger(EmailMessage.class);
    private static Session session;
    private static EmailAuthenticator authenticator;
    private static String defaultEncoding;
    private List<InternetAddress> cc = new ArrayList<InternetAddress>();
    private List<InternetAddress> bcc = new ArrayList<InternetAddress>();
    private List<AttachmentFile> attachments = new ArrayList<AttachmentFile>();
    private static volatile EmailMessage getInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EmailMessage getInstance() {
        if (getInstance != null) return getInstance;
        Class<EmailMessage> clazz = EmailMessage.class;
        synchronized (EmailMessage.class) {
            if (getInstance != null) return getInstance;
            getInstance = new EmailMessage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return getInstance;
        }
    }

    private EmailMessage() {
    }

    private static Properties defaultConfig() {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.debug", "false");
        props.put("mail.smtp.timeout", "10000");
        props.put("mail.smtp.port", (Object)25);
        return props;
    }

    public static Properties SMTP_ENT_QQ() {
        Properties props = EmailMessage.defaultConfig();
        props.put("mail.smtp.host", "smtp.exmail.qq.com");
        return props;
    }

    public static Properties SMTP_QQ() {
        Properties props = EmailMessage.defaultConfig();
        props.put("mail.smtp.host", "smtp.qq.com");
        return props;
    }

    public static Properties SMTP_163() {
        Properties props = EmailMessage.defaultConfig();
        props.put("mail.smtp.host", "smtp.163.com");
        return props;
    }

    public static void config(Properties props, String username, String password) {
        EmailMessage.config(props, username, password, null, null);
    }

    public static void config(Properties props, String username, String password, String templatePath) {
        EmailMessage.config(props, username, password, templatePath, 2);
    }

    public static void config(Properties props, String username, String password, String templatePath, Integer type) {
        if (StrUtil.isNotBlank((CharSequence)templatePath)) {
            FreemarkerUtil.initFreeMarker(templatePath, type);
            authenticator = new EmailAuthenticator(username, password, props.getProperty("mail.smtp.host"), templatePath);
        } else {
            authenticator = new EmailAuthenticator(username, password, props.getProperty("mail.smtp.host"));
        }
        session = Session.getDefaultInstance((Properties)props, (Authenticator)authenticator);
    }

    public static synchronized EmailResult sendTextEmail(String subject, String content, String from, String[] receivers) {
        return EmailMessage.sendTextEmail(subject, content, from, null, receivers);
    }

    public static synchronized EmailResult sendTextEmail(String subject, String content, String from, String fromName, String[] receivers) {
        return EmailMessage.sendTextEmail(subject, content, false, from, fromName, receivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EmailResult sendTextEmail(String subject, String content, boolean isDebug, String from, String fromName, String[] receivers) {
        EmailResult result = new EmailResult();
        Transport transport = null;
        try {
            session.setDebug(isDebug);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            if (StrUtil.isBlank((CharSequence)fromName)) {
                message.setFrom((Address)new InternetAddress(from));
            } else {
                message.setFrom((Address)new InternetAddress(from, fromName, defaultEncoding));
            }
            message.setSubject(subject);
            for (InternetAddress to : MailUtil.getReceivers(receivers)) {
                message.addRecipient(Message.RecipientType.TO, (Address)to);
            }
            if (ListUtil.isNotEmpty(EmailMessage.getInstance().cc)) {
                message.setRecipients(Message.RecipientType.CC, (Address[])EmailMessage.getInstance().cc.stream().toArray(Address[]::new));
            }
            if (ListUtil.isNotEmpty(EmailMessage.getInstance().bcc)) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])EmailMessage.getInstance().bcc.stream().toArray(Address[]::new));
            }
            MimeMultipart multipart = new MimeMultipart();
            if (EmptyUtil.isNotEmpty(content).booleanValue()) {
                MimeBodyPart contentPart = new MimeBodyPart();
                contentPart.setText(CastUtil.castString(content));
                multipart.addBodyPart((BodyPart)contentPart);
            }
            if (EmailMessage.getInstance().attachments != null && EmailMessage.getInstance().attachments.size() > 0) {
                for (AttachmentFile file : EmailMessage.getInstance().attachments) {
                    MimeBodyPart filesPart = new MimeBodyPart();
                    filesPart.setDataHandler(file.getFile());
                    filesPart.setFileName(file.getFileName());
                    multipart.addBodyPart((BodyPart)filesPart);
                }
            }
            message.setSentDate(new Date());
            message.setContent((Multipart)multipart);
            message.saveChanges();
            transport = session.getTransport();
            transport.connect(authenticator.getHost(), authenticator.getUsername(), authenticator.getPassword());
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
            result.setStatus("success");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff01");
        }
        catch (AuthenticationFailedException e) {
            result.setStatus("failed");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0:\u8eab\u4efd\u9a8c\u8bc1\u9519\u8bef\uff01");
            if (isDebug) {
                e.printStackTrace();
            }
        }
        catch (MessagingException e) {
            result.setStatus("failed");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
            if (isDebug) {
                Exception ex = null;
                ex = e.getNextException();
                if (ex != null) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            result.setStatus("failed");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a\u672a\u77e5");
            if (isDebug) {
                e.printStackTrace();
            }
        }
        finally {
            block33: {
                if (null != transport) {
                    try {
                        transport.close();
                    }
                    catch (MessagingException e) {
                        if (!isDebug) break block33;
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static synchronized EmailResult sendHtmlEmail(String subject, String templateName, Map<String, Object> params, String from, String[] receivers) {
        return EmailMessage.sendHtmlEmail(subject, templateName, params, false, from, null, receivers);
    }

    public static synchronized EmailResult sendHtmlEmail(String subject, String templateName, Map<String, Object> params, String from, String fromName, String[] receivers) {
        return EmailMessage.sendHtmlEmail(subject, templateName, params, false, from, fromName, receivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EmailResult sendHtmlEmail(String subject, String templateName, Map<String, Object> params, boolean isDebug, String from, String fromName, String[] receivers) {
        EmailResult result = new EmailResult();
        Transport transport = null;
        try {
            session.setDebug(isDebug);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            if (StrUtil.isBlank((CharSequence)fromName)) {
                message.setFrom((Address)new InternetAddress(from));
            } else {
                message.setFrom((Address)new InternetAddress(from, fromName, defaultEncoding));
            }
            message.setSubject(subject);
            for (InternetAddress to : MailUtil.getReceivers(receivers)) {
                message.addRecipient(Message.RecipientType.TO, (Address)to);
            }
            if (ListUtil.isNotEmpty(EmailMessage.getInstance().cc)) {
                message.setRecipients(Message.RecipientType.CC, (Address[])EmailMessage.getInstance().cc.stream().toArray(Address[]::new));
            }
            if (ListUtil.isNotEmpty(EmailMessage.getInstance().bcc)) {
                message.setRecipients(Message.RecipientType.BCC, (Address[])EmailMessage.getInstance().bcc.stream().toArray(Address[]::new));
            }
            message.setSentDate(new Date());
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setContent((Object)FreemarkerUtil.crateHTML(templateName, params), "text/html;charset=UTF-8");
            multipart.addBodyPart((BodyPart)bodyPart);
            if (EmailMessage.getInstance().attachments != null && EmailMessage.getInstance().attachments.size() > 0) {
                for (AttachmentFile file : EmailMessage.getInstance().attachments) {
                    MimeBodyPart filesPart = new MimeBodyPart();
                    filesPart.setDataHandler(file.getFile());
                    filesPart.setFileName(file.getFileName());
                    multipart.addBodyPart((BodyPart)filesPart);
                }
            }
            message.setContent((Multipart)multipart);
            message.saveChanges();
            transport = session.getTransport();
            transport.connect(authenticator.getHost(), authenticator.getUsername(), authenticator.getPassword());
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
            result.setStatus("success");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u6210\u529f\uff01");
        }
        catch (AuthenticationFailedException e) {
            result.setStatus("failed");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0:\u8eab\u4efd\u9a8c\u8bc1\u9519\u8bef\uff01");
            if (isDebug) {
                e.printStackTrace();
            }
        }
        catch (MessagingException e) {
            result.setStatus("failed");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
            if (isDebug) {
                Exception ex = null;
                ex = e.getNextException();
                if (ex != null) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            result.setStatus("failed");
            result.setMsg("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a\u672a\u77e5");
            if (isDebug) {
                e.printStackTrace();
            }
        }
        finally {
            block32: {
                if (null != transport) {
                    try {
                        transport.close();
                    }
                    catch (MessagingException e) {
                        if (!isDebug) break block32;
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public void sendCC(List<String> cc) {
        try {
            if (cc != null && cc.size() > 0) {
                ArrayList<InternetAddress> ccList = new ArrayList<InternetAddress>();
                for (int i = 0; i < cc.size(); ++i) {
                    String ccTmp = cc.get(i);
                    ccList.add(new InternetAddress(ccTmp));
                }
                this.cc = ccList;
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u8bbe\u7f6e\u6284\u9001\u4eba\u5f02\u5e38");
        }
    }

    public void sendBCC(List<String> bcc) {
        try {
            if (bcc != null && bcc.size() > 0) {
                ArrayList<InternetAddress> bccList = new ArrayList<InternetAddress>();
                for (int i = 0; i < bcc.size(); ++i) {
                    String bccTmp = bcc.get(i);
                    bccList.add(new InternetAddress(bccTmp));
                }
                this.bcc = bccList;
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u8bbe\u7f6e\u5bc6\u9001\u4eba\u5f02\u5e38");
        }
    }

    public void sendFilesPath(String filepath) {
        try {
            if (StrUtil.isNotBlank((CharSequence)filepath)) {
                FileDataSource fds = new FileDataSource(filepath);
                this.attachments.add(new AttachmentFile(MimeUtility.encodeText((String)fds.getName()), new DataHandler((DataSource)fds)));
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u8bbe\u7f6e\u9644\u4ef6\u5f02\u5e38");
        }
    }

    public void sendFilesPath(List<String> filepath) {
        try {
            if (filepath != null && filepath.size() > 0) {
                for (String filename : filepath) {
                    FileDataSource fds = new FileDataSource(filename);
                    this.attachments.add(new AttachmentFile(MimeUtility.encodeText((String)fds.getName()), new DataHandler((DataSource)fds)));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u8bbe\u7f6e\u9644\u4ef6\u5f02\u5e38");
        }
    }

    public void sendFiles(File filepath) {
        try {
            FileDataSource fds = new FileDataSource(filepath);
            this.attachments.add(new AttachmentFile(MimeUtility.encodeText((String)fds.getName()), new DataHandler((DataSource)fds)));
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u8bbe\u7f6e\u9644\u4ef6\u5f02\u5e38");
        }
    }

    public void sendFiles(List<File> filepath) {
        try {
            if (filepath != null && filepath.size() > 0) {
                for (File filename : filepath) {
                    FileDataSource fds = new FileDataSource(filename);
                    this.attachments.add(new AttachmentFile(MimeUtility.encodeText((String)fds.getName()), new DataHandler((DataSource)fds)));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u90ae\u4ef6\u8bbe\u7f6e\u9644\u4ef6\u5f02\u5e38");
        }
    }

    public static String createContent(String username, Date startTime, String validtime) {
        String content = "<style type='text/css'>*{font:16px 'microsoft yahie';color:#333;}#mailcontent{border:1px solid #ccc;width:900px; height:auto;margin:0 auto;background:#fff;padding:20px 50px 35px 50px;}#mailcontent a{text-align:center;display:block;width:900px;height:auto;padding:20px 0;color:#000;}#mailcontent .resetpwd{display:block;width:100px;height:20px;padding:5px;font:16px 'microsoft yahei';background:#f2f2f2;border:1px solid #bbb;text-align:center;margin-top:24px;border-radius:2px;color:#666;text-decoration:none;margin-left:30px;}#mailcontent .resetpwd:hover{text-decoration:none;color:#fff;box-shadow:0 0 5px rgba(20,20,20,0.3);background:#19b4ea;}#mailcontent .from{text-align:right;margin-top:40px;}</style><div id='mailcontent'><a href='\u6d4b\u8bd5'><img alt='logo' src='\u6d4b\u8bd5/resources/images/biglogo.png'/></a><p>\u4eb2\u7231\u7684" + username + "\u7528\u6237\uff1a</p><p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\u8fd9\u662f\u4e00\u5c01\u6765\u81ea<a style='display:inline' href='\u6d4b\u8bd5'>JAVA\u6280\u672f\u8bba\u575b</a>\u7684\u90ae\u4ef6\uff0c\u672c\u90ae\u4ef6\u7528\u4e8e\u627e\u56de\u5bc6\u7801\uff0c\u8bf7\u5148\u786e\u5b9a\u8fd9\u662f\u5426\u662f\u60a8\u672c\u4eba\u64cd\u4f5c\uff0c\u5982\u679c\u4e0d\u662f\uff0c\u8bf7\u5ffd\u7565\u6b64\u90ae\u4ef6\uff0c\u5982\u679c\u662f\u60a8\u672c\u4eba\u64cd\u4f5c\uff0c\u90a3\u4e48\u8bf7\u6ce8\u610f\u4ee5\u4e0b\u4e8b\u9879\uff1a</p><ol><li>\u672c\u90ae\u4ef6\u6709\u6548\u671f\u4e3a" + validtime + "\u5206\u949f\uff0c\u8bf7\u5728\u6709\u6548\u65f6\u95f4\u5185\u70b9\u51fb\u4e0b\u65b9\u6309\u94ae\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e</li><li>\u5982\u679c\u6309\u94ae\u65e0\u6cd5\u70b9\u51fb\uff0c\u8bf7\u590d\u5236\u4e0b\u65b9\u94fe\u63a5\u7c98\u8d34\u81f3\u6d4f\u89c8\u5668\u5730\u5740\u680f</li><li>\u6b64\u90ae\u4ef6\u4e3a\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001\uff0c\u8bf7\u52ff\u56de\u590d</li></ol><a class='resetpwd' href='\u6d4b\u8bd5'>\u70b9\u51fb\u91cd\u7f6e\u5bc6\u7801</a><p>\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5\uff1a\u6d4b\u8bd5</p><p>\u5982\u679c\u6709\u4efb\u4f55\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\uff0c\u90ae\u7bb1\u5730\u5740\uff1a<a style='display:inline' href='mailto:bbshelp@163.com'>bbshelp@163.com</a></p><div class='from'><span>\u6765\u81eaBBS</span><p>" + TimeUtil.format(startTime, "yyyyMMddHH") + "</p></div></div>";
        return content;
    }

    public static void main(String[] args) {
        EmailMessage.config(EmailMessage.SMTP_ENT_QQ(), "ncai@netconcepts.cn", "rP6S45YWrk5A4kff");
        ArrayList<String> cc = new ArrayList<String>();
        cc.add("wangzhiqiang@netconcepts.cn");
        EmailMessage.getInstance().sendCC(cc);
        String content = EmailMessage.createContent("\u5148\u751f", new Date(), "1");
        ArrayList<String> file = new ArrayList<String>();
        file.add("/Users/cloud/Desktop/\u65b0\u65e7\u8868\u5173\u7cfb.txt");
        EmailMessage.getInstance().sendFilesPath(file);
        System.out.println(EmailMessage.sendTextEmail("NCAI\u90ae\u4ef6\u6d4b\u8bd5", "\u6d4b\u8bd5", "ncai@netconcepts.cn", "\u6d4b\u8bd5\u5de5\u7a0b\u5e08", "yangheqing@netconcepts.cn".split(",")));
        EmailMessage.config(EmailMessage.SMTP_ENT_QQ(), "ncai@netconcepts.cn", "rP6S45YWrk5A4kff", "/template");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userName", "\u6d4b\u8bd5");
        params.put("age", 12);
        ArrayList<String> file1 = new ArrayList<String>();
        file.add("/Users/cloud/Desktop/\u65b0\u65e7\u8868\u5173\u7cfb.txt");
        EmailMessage.getInstance().sendFilesPath(file1);
        System.out.println(EmailMessage.sendHtmlEmail("NCAI\u90ae\u4ef6\u6d4b\u8bd5", "user.ftl", params, "ncai@netconcepts.cn", "\u6d4b\u8bd5\u5de5\u7a0b\u5e08", "yangheqing@netconcepts.cn".split(",")));
    }

    static {
        defaultEncoding = "UTF-8";
        getInstance = null;
    }
}

