/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.xml;

import cn.dolphin.core.exception.UtilsRuntimeException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JaxbUtil {
    public static String convertToXml(Object obj) {
        return JaxbUtil.convertToXml(obj, "UTF-8");
    }

    private static String convertToXml(Object obj, String encoding) {
        String result = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            StringWriter writer = new StringWriter();
            marshaller.marshal(obj, (Writer)writer);
            result = writer.toString();
            result = result.replaceFirst(" standalone=\"yes\"", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static <T> T convertToJavaBean(String xml, Class<T> c) throws UtilsRuntimeException {
        Object t = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            t = unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UtilsRuntimeException("The input is not a correct json.");
        }
        return (T)t;
    }
}

