/*
 * Decompiled with CFR 0.152.
 */
package cn.dolphin.core.xml;

import cn.dolphin.core.util.ExceptionUtil;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class Dom4jUtil {
    public static Map toMap(String xml, String charset) {
        try {
            SAXReader reader = new SAXReader(false);
            InputSource source = new InputSource(new ByteArrayInputStream(xml.getBytes()));
            source.setEncoding(charset);
            Document doc = reader.read(source);
            return Dom4jUtil.toMap(doc.getRootElement());
        }
        catch (Exception e) {
            ExceptionUtil.printErrorInfo(e);
            return null;
        }
    }

    public static String toXml(Map<?, ?> params) {
        StringBuilder buf = new StringBuilder();
        buf.append("<xml>");
        for (Map.Entry<?, ?> entry : params.entrySet()) {
            buf.append("<").append(entry.getKey()).append(">");
            buf.append("<![CDATA[").append(entry.getValue()).append("]]>");
            buf.append("</").append(entry.getKey()).append(">\n");
        }
        buf.append("</xml>");
        return buf.toString();
    }

    private static Map toMap(Element element) {
        ConcurrentMap rest = Maps.newConcurrentMap();
        List els = element.elements();
        for (Object object : els) {
            if (!(object instanceof Element)) continue;
            Element el = (Element)object;
            rest.put(el.getName(), el.getTextTrim());
        }
        return rest;
    }

    private Dom4jUtil() {
    }
}

